/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common.pathelement;

import com.bazaarvoice.jolt.common.WalkedPath;
import com.bazaarvoice.jolt.common.pathelement.BasePathElement;
import com.bazaarvoice.jolt.common.pathelement.EvaluatablePathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.MatchablePathElement;
import com.bazaarvoice.jolt.common.pathelement.TransposePathElement;
import com.bazaarvoice.jolt.common.reference.AmpReference;
import com.bazaarvoice.jolt.common.reference.HashReference;
import com.bazaarvoice.jolt.common.reference.PathAndGroupReference;
import com.bazaarvoice.jolt.common.reference.PathReference;
import com.bazaarvoice.jolt.exception.SpecException;

public class ArrayPathElement
extends BasePathElement
implements MatchablePathElement,
EvaluatablePathElement {
    private final ArrayPathType arrayPathType;
    private final PathReference ref;
    private final TransposePathElement transposePathElement;
    private final String canonicalForm;
    private final String arrayIndex;

    public ArrayPathElement(String key) {
        super(key);
        ArrayPathType apt;
        if (key.charAt(0) != '[' || key.charAt(key.length() - 1) != ']') {
            throw new SpecException("Invalid ArrayPathElement key:" + key);
        }
        PathReference r = null;
        TransposePathElement tpe = null;
        String aI = "";
        if (key.length() == 2) {
            apt = ArrayPathType.AUTO_EXPAND;
            this.canonicalForm = "[]";
        } else {
            String meat = key.substring(1, key.length() - 1);
            char firstChar = meat.charAt(0);
            if (AmpReference.TOKEN.equals(Character.valueOf(firstChar))) {
                r = new AmpReference(meat);
                apt = ArrayPathType.REFERENCE;
                this.canonicalForm = "[" + r.getCanonicalForm() + "]";
            } else if (HashReference.TOKEN.equals(Character.valueOf(firstChar))) {
                r = new HashReference(meat);
                apt = ArrayPathType.HASH;
                this.canonicalForm = "[" + r.getCanonicalForm() + "]";
            } else if ('@' == firstChar) {
                apt = ArrayPathType.TRANSPOSE;
                tpe = TransposePathElement.parse(meat);
                this.canonicalForm = "[" + tpe.getCanonicalForm() + "]";
            } else {
                aI = ArrayPathElement.verifyStringIsNonNegativeInteger(meat);
                if (aI != null) {
                    apt = ArrayPathType.EXPLICIT_INDEX;
                    this.canonicalForm = "[" + aI + "]";
                } else {
                    throw new SpecException("Bad explict array index:" + meat + " from key:" + key);
                }
            }
        }
        this.transposePathElement = tpe;
        this.arrayPathType = apt;
        this.ref = r;
        this.arrayIndex = aI;
    }

    @Override
    public String getCanonicalForm() {
        return this.canonicalForm;
    }

    @Override
    public String evaluate(WalkedPath walkedPath) {
        switch (this.arrayPathType) {
            case AUTO_EXPAND: {
                return this.canonicalForm;
            }
            case EXPLICIT_INDEX: {
                return this.arrayIndex;
            }
            case HASH: {
                LiteralPathElement element = walkedPath.elementFromEnd(this.ref.getPathIndex()).getLiteralPathElement();
                Integer index = element.getHashCount();
                return index.toString();
            }
            case TRANSPOSE: {
                String key = this.transposePathElement.evaluate(walkedPath);
                return ArrayPathElement.verifyStringIsNonNegativeInteger(key);
            }
            case REFERENCE: {
                LiteralPathElement lpe = walkedPath.elementFromEnd(this.ref.getPathIndex()).getLiteralPathElement();
                String keyPart = this.ref instanceof PathAndGroupReference ? lpe.getSubKeyRef(((PathAndGroupReference)this.ref).getKeyGroup()) : lpe.getSubKeyRef(0);
                return ArrayPathElement.verifyStringIsNonNegativeInteger(keyPart);
            }
        }
        throw new IllegalStateException("ArrayPathType enum added two without updating this switch statement.");
    }

    private static String verifyStringIsNonNegativeInteger(String key) {
        try {
            int number = Integer.parseInt(key);
            if (number >= 0) {
                return key;
            }
            return null;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    @Override
    public LiteralPathElement match(String dataKey, WalkedPath walkedPath) {
        String evaled = this.evaluate(walkedPath);
        if (evaled.equals(dataKey)) {
            return new LiteralPathElement(evaled);
        }
        return null;
    }

    public static enum ArrayPathType {
        AUTO_EXPAND,
        REFERENCE,
        HASH,
        TRANSPOSE,
        EXPLICIT_INDEX;

    }
}

