/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common.pathelement;

import com.bazaarvoice.jolt.common.WalkedPath;
import com.bazaarvoice.jolt.common.pathelement.BasePathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.MatchablePathElement;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.utils.StringTools;

public class HashPathElement
extends BasePathElement
implements MatchablePathElement {
    private final String keyValue;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HashPathElement(String key) {
        super(key);
        if (StringTools.isBlank(key)) {
            throw new SpecException("HashPathElement cannot have empty String as input.");
        }
        if (!key.startsWith("#")) {
            throw new SpecException("LHS # should start with a # : " + key);
        }
        if (key.length() <= 1) {
            throw new SpecException("HashPathElement input is too short : " + key);
        }
        if (key.charAt(1) == '(') {
            if (key.charAt(key.length() - 1) != ')') throw new SpecException("HashPathElement, mismatched parens : " + key);
            this.keyValue = key.substring(2, key.length() - 1);
            return;
        } else {
            this.keyValue = key.substring(1);
        }
    }

    @Override
    public String getCanonicalForm() {
        return "#(" + this.keyValue + ")";
    }

    @Override
    public LiteralPathElement match(String dataKey, WalkedPath walkedPath) {
        return new LiteralPathElement(this.keyValue);
    }
}

