/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common.pathelement;

import com.bazaarvoice.jolt.common.WalkedPath;
import com.bazaarvoice.jolt.common.pathelement.BasePathElement;
import com.bazaarvoice.jolt.common.pathelement.EvaluatablePathElement;
import com.bazaarvoice.jolt.common.pathelement.MatchablePathElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LiteralPathElement
extends BasePathElement
implements MatchablePathElement,
EvaluatablePathElement {
    private final List<String> subKeys;
    private int hashCount = 0;

    public LiteralPathElement(String key) {
        super(key);
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add(key);
        this.subKeys = Collections.unmodifiableList(keys);
    }

    public LiteralPathElement(String key, List<String> subKeys) {
        super(key);
        if (subKeys == null) {
            throw new IllegalArgumentException("LiteralPathElement for key:" + key + " got null list of subKeys");
        }
        ArrayList<String> keys = new ArrayList<String>(1 + subKeys.size());
        keys.add(key);
        keys.addAll(subKeys);
        this.subKeys = Collections.unmodifiableList(keys);
    }

    @Override
    public String evaluate(WalkedPath walkedPath) {
        return this.getRawKey();
    }

    @Override
    public LiteralPathElement match(String dataKey, WalkedPath walkedPath) {
        if (this.getRawKey().equals(dataKey)) {
            return new LiteralPathElement(this.getRawKey(), this.subKeys);
        }
        return null;
    }

    @Override
    public String getCanonicalForm() {
        return this.getRawKey();
    }

    public String getSubKeyRef(int index) {
        if (index < 0 || index >= this.subKeys.size()) {
            throw new IndexOutOfBoundsException("LiteralPathElement " + this.subKeys + " cannot be indexed with index " + index);
        }
        return this.subKeys.get(index);
    }

    public int getSubKeyCount() {
        return this.subKeys.size();
    }

    public int getHashCount() {
        return this.hashCount;
    }

    public void incrementHashCount() {
        ++this.hashCount;
    }
}

