/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.shiftr;

import com.bazaarvoice.jolt.common.WalkedPath;
import com.bazaarvoice.jolt.common.pathelement.EvaluatablePathElement;
import com.bazaarvoice.jolt.common.pathelement.PathElement;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.shiftr.spec.ShiftrSpec;
import com.bazaarvoice.jolt.traversr.Traversr;
import com.bazaarvoice.jolt.utils.StringTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class PathEvaluatingTraversal {
    private final List<EvaluatablePathElement> elements;
    private final Traversr traversr;

    public PathEvaluatingTraversal(String dotNotation) {
        Traversr trav;
        List<Object> paths;
        if (dotNotation.contains("*") || dotNotation.contains("$")) {
            throw new SpecException("DotNotation (write key) can not contain '*' or '$' : write key: " + dotNotation);
        }
        if (StringTools.isNotBlank(dotNotation)) {
            paths = ShiftrSpec.parseDotNotationRHS(dotNotation);
            ArrayList<String> traversrPaths = new ArrayList<String>(paths.size());
            for (PathElement pathElement : paths) {
                traversrPaths.add(pathElement.getCanonicalForm());
            }
            trav = this.createTraversr(traversrPaths);
        } else {
            paths = Collections.emptyList();
            trav = this.createTraversr(Arrays.asList(""));
        }
        ArrayList<EvaluatablePathElement> evalPaths = new ArrayList<EvaluatablePathElement>(paths.size());
        for (PathElement pathElement : paths) {
            if (!(pathElement instanceof EvaluatablePathElement)) {
                throw new SpecException("RHS key=" + pathElement.getRawKey() + " is not a valid RHS key.");
            }
            evalPaths.add((EvaluatablePathElement)pathElement);
        }
        this.elements = Collections.unmodifiableList(evalPaths);
        this.traversr = trav;
    }

    protected abstract Traversr createTraversr(List<String> var1);

    public void write(Object data, Map<String, Object> output, WalkedPath walkedPath) {
        List<String> evaledPaths = this.evaluate(walkedPath);
        if (evaledPaths != null) {
            this.traversr.set(output, evaledPaths, data);
        }
    }

    public Object read(Object data, WalkedPath walkedPath) {
        List<String> evaledPaths = this.evaluate(walkedPath);
        if (evaledPaths == null) {
            return null;
        }
        return this.traversr.get(data, evaledPaths);
    }

    List<String> evaluate(WalkedPath walkedPath) {
        ArrayList<String> strings = new ArrayList<String>(this.elements.size());
        for (EvaluatablePathElement pathElement : this.elements) {
            String evaledLeafOutput = pathElement.evaluate(walkedPath);
            if (evaledLeafOutput == null) {
                return null;
            }
            strings.add(evaledLeafOutput);
        }
        return strings;
    }

    public int size() {
        return this.elements.size();
    }

    public PathElement get(int index) {
        return this.elements.get(index);
    }

    public String getCanonicalForm() {
        StringBuilder buf = new StringBuilder();
        for (PathElement pathElement : this.elements) {
            buf.append(".").append(pathElement.getCanonicalForm());
        }
        return buf.substring(1);
    }
}

