/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.shiftr.spec;

import com.bazaarvoice.jolt.common.WalkedPath;
import com.bazaarvoice.jolt.common.pathelement.AmpPathElement;
import com.bazaarvoice.jolt.common.pathelement.AtPathElement;
import com.bazaarvoice.jolt.common.pathelement.DollarPathElement;
import com.bazaarvoice.jolt.common.pathelement.HashPathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.MatchablePathElement;
import com.bazaarvoice.jolt.common.pathelement.StarAllPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarDoublePathElement;
import com.bazaarvoice.jolt.common.pathelement.StarPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarRegexPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarSinglePathElement;
import com.bazaarvoice.jolt.common.pathelement.TransposePathElement;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.shiftr.spec.ShiftrLeafSpec;
import com.bazaarvoice.jolt.shiftr.spec.ShiftrSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ShiftrCompositeSpec
extends ShiftrSpec {
    private static final ComputedKeysComparator computedKeysComparator = new ComputedKeysComparator();
    private final List<ShiftrSpec> specialChildren;
    private final Map<String, ShiftrSpec> literalChildren;
    private final List<ShiftrSpec> computedChildren;
    private final ExecutionStrategy executionStrategy;

    public ShiftrCompositeSpec(String rawKey, Map<String, Object> spec) {
        super(rawKey);
        ArrayList<ShiftrSpec> special = new ArrayList<ShiftrSpec>();
        LinkedHashMap<String, ShiftrSpec> literals = new LinkedHashMap<String, ShiftrSpec>();
        ArrayList<ShiftrSpec> computed = new ArrayList<ShiftrSpec>();
        if (this.pathElement instanceof AtPathElement) {
            throw new SpecException("@ Shiftr key, can not have children.");
        }
        if (this.pathElement instanceof DollarPathElement) {
            throw new SpecException("$ Shiftr key, can not have children.");
        }
        List<ShiftrSpec> children = ShiftrCompositeSpec.createChildren(spec);
        if (children.isEmpty()) {
            throw new SpecException("Shift ShiftrSpec format error : ShiftrSpec line with empty {} as value is not valid.");
        }
        for (ShiftrSpec child : children) {
            if (child.pathElement instanceof LiteralPathElement) {
                literals.put(child.pathElement.getRawKey(), child);
                continue;
            }
            if (child.pathElement instanceof AtPathElement || child.pathElement instanceof HashPathElement || child.pathElement instanceof DollarPathElement || child.pathElement instanceof TransposePathElement) {
                special.add(child);
                continue;
            }
            computed.add(child);
        }
        Collections.sort(computed, computedKeysComparator);
        special.trimToSize();
        computed.trimToSize();
        this.specialChildren = Collections.unmodifiableList(special);
        this.literalChildren = Collections.unmodifiableMap(literals);
        this.computedChildren = Collections.unmodifiableList(computed);
        this.executionStrategy = ExecutionStrategy.determineStrategy(this.literalChildren, this.computedChildren);
    }

    private static List<ShiftrSpec> createChildren(Map<String, Object> rawSpec) {
        ArrayList<ShiftrSpec> result = new ArrayList<ShiftrSpec>();
        HashSet<String> actualKeys = new HashSet<String>();
        for (String rawLhsStr : rawSpec.keySet()) {
            String[] keyStrings;
            Object rawRhs = rawSpec.get(rawLhsStr);
            for (String keyString : keyStrings = rawLhsStr.split("\\|")) {
                ShiftrSpec childSpec = rawRhs instanceof Map ? new ShiftrCompositeSpec(keyString, (Map)rawRhs) : new ShiftrLeafSpec(keyString, rawRhs);
                String childCanonicalString = childSpec.pathElement.getCanonicalForm();
                if (actualKeys.contains(childCanonicalString)) {
                    throw new IllegalArgumentException("Duplicate canonical Shiftr key found : " + childCanonicalString);
                }
                actualKeys.add(childCanonicalString);
                result.add(childSpec);
            }
        }
        return result;
    }

    List<ShiftrSpec> getComputedChildren() {
        return this.computedChildren;
    }

    @Override
    public boolean apply(String inputKey, Object input, WalkedPath walkedPath, Map<String, Object> output) {
        LiteralPathElement thisLevel = this.pathElement.match(inputKey, walkedPath);
        if (thisLevel == null) {
            return false;
        }
        walkedPath.add(input, thisLevel);
        for (ShiftrSpec subSpec : this.specialChildren) {
            subSpec.apply(inputKey, input, walkedPath, output);
        }
        this.executionStrategy.process(this, input, walkedPath, output);
        walkedPath.removeLast();
        walkedPath.lastElement().getLiteralPathElement().incrementHashCount();
        return true;
    }

    public static class ComputedKeysComparator
    implements Comparator<ShiftrSpec> {
        private static final HashMap<Class, Integer> orderMap = new HashMap();

        @Override
        public int compare(ShiftrSpec a, ShiftrSpec b) {
            int blen;
            int elementsEqual;
            int bb;
            MatchablePathElement ape = a.pathElement;
            MatchablePathElement bpe = b.pathElement;
            int aa = orderMap.get(ape.getClass());
            int n = aa < (bb = orderMap.get(bpe.getClass()).intValue()) ? -1 : (elementsEqual = aa == bb ? 0 : 1);
            if (elementsEqual != 0) {
                return elementsEqual;
            }
            String acf = ape.getCanonicalForm();
            String bcf = bpe.getCanonicalForm();
            int alen = acf.length();
            return alen > (blen = bcf.length()) ? -1 : (alen == blen ? acf.compareTo(bcf) : 1);
        }

        static {
            orderMap.put(AmpPathElement.class, 1);
            orderMap.put(StarRegexPathElement.class, 2);
            orderMap.put(StarDoublePathElement.class, 3);
            orderMap.put(StarSinglePathElement.class, 4);
            orderMap.put(StarAllPathElement.class, 5);
        }
    }

    private static enum ExecutionStrategy {
        LITERALS_ONLY{

            @Override
            void processMap(ShiftrCompositeSpec spec, Map<String, Object> inputMap, WalkedPath walkedPath, Map<String, Object> output) {
                for (String key : spec.literalChildren.keySet()) {
                    if (!inputMap.containsKey(key)) continue;
                    Object subInput = inputMap.get(key);
                    ((ShiftrSpec)spec.literalChildren.get(key)).apply(key, subInput, walkedPath, output);
                }
            }

            @Override
            void processList(ShiftrCompositeSpec spec, List<Object> inputList, WalkedPath walkedPath, Map<String, Object> output) {
                for (String key : spec.literalChildren.keySet()) {
                    int keyInt = Integer.MAX_VALUE;
                    try {
                        keyInt = Integer.parseInt(key);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (keyInt >= inputList.size()) continue;
                    Object subInput = inputList.get(keyInt);
                    ((ShiftrSpec)spec.literalChildren.get(key)).apply(key, subInput, walkedPath, output);
                }
            }

            @Override
            void processScalar(ShiftrCompositeSpec spec, String scalarInput, WalkedPath walkedPath, Map<String, Object> output) {
                ShiftrSpec literalChild = (ShiftrSpec)spec.literalChildren.get(scalarInput);
                if (literalChild != null) {
                    literalChild.apply(scalarInput, null, walkedPath, output);
                }
            }
        }
        ,
        COMPUTED_ONLY{

            @Override
            void processMap(ShiftrCompositeSpec spec, Map<String, Object> inputMap, WalkedPath walkedPath, Map<String, Object> output) {
                for (Map.Entry<String, Object> inputEntry : inputMap.entrySet()) {
                    ExecutionStrategy.applyKeyToComputed(spec.computedChildren, walkedPath, output, inputEntry.getKey(), inputEntry.getValue());
                }
            }

            @Override
            void processList(ShiftrCompositeSpec spec, List<Object> inputList, WalkedPath walkedPath, Map<String, Object> output) {
                for (int index = 0; index < inputList.size(); ++index) {
                    Object subInput = inputList.get(index);
                    String subKeyStr = Integer.toString(index);
                    ExecutionStrategy.applyKeyToComputed(spec.computedChildren, walkedPath, output, subKeyStr, subInput);
                }
            }

            @Override
            void processScalar(ShiftrCompositeSpec spec, String scalarInput, WalkedPath walkedPath, Map<String, Object> output) {
                ExecutionStrategy.applyKeyToComputed(spec.computedChildren, walkedPath, output, scalarInput, null);
            }
        }
        ,
        CONFLICT{

            @Override
            void processMap(ShiftrCompositeSpec spec, Map<String, Object> inputMap, WalkedPath walkedPath, Map<String, Object> output) {
                for (Map.Entry<String, Object> inputEntry : inputMap.entrySet()) {
                    ExecutionStrategy.applyKeyToLiteralAndComputed(spec, inputEntry.getKey(), inputEntry.getValue(), walkedPath, output);
                }
            }

            @Override
            void processList(ShiftrCompositeSpec spec, List<Object> inputList, WalkedPath walkedPath, Map<String, Object> output) {
                for (int index = 0; index < inputList.size(); ++index) {
                    Object subInput = inputList.get(index);
                    String subKeyStr = Integer.toString(index);
                    ExecutionStrategy.applyKeyToLiteralAndComputed(spec, subKeyStr, subInput, walkedPath, output);
                }
            }

            @Override
            void processScalar(ShiftrCompositeSpec spec, String scalarInput, WalkedPath walkedPath, Map<String, Object> output) {
                ExecutionStrategy.applyKeyToLiteralAndComputed(spec, scalarInput, null, walkedPath, output);
            }
        }
        ,
        NO_CONFLICT{

            @Override
            void processMap(ShiftrCompositeSpec spec, Map<String, Object> inputMap, WalkedPath walkedPath, Map<String, Object> output) {
                LITERALS_ONLY.processMap(spec, inputMap, walkedPath, output);
                COMPUTED_ONLY.processMap(spec, inputMap, walkedPath, output);
            }

            @Override
            void processList(ShiftrCompositeSpec spec, List<Object> inputList, WalkedPath walkedPath, Map<String, Object> output) {
                LITERALS_ONLY.processList(spec, inputList, walkedPath, output);
                COMPUTED_ONLY.processList(spec, inputList, walkedPath, output);
            }

            @Override
            void processScalar(ShiftrCompositeSpec spec, String scalarInput, WalkedPath walkedPath, Map<String, Object> output) {
                LITERALS_ONLY.processScalar(spec, scalarInput, walkedPath, output);
                COMPUTED_ONLY.processScalar(spec, scalarInput, walkedPath, output);
            }
        };


        public void process(ShiftrCompositeSpec spec, Object input, WalkedPath walkedPath, Map<String, Object> output) {
            if (input instanceof Map) {
                this.processMap(spec, (Map)input, walkedPath, output);
            } else if (input instanceof List) {
                this.processList(spec, (List)input, walkedPath, output);
            } else if (input != null) {
                this.processScalar(spec, input.toString(), walkedPath, output);
            }
        }

        abstract void processMap(ShiftrCompositeSpec var1, Map<String, Object> var2, WalkedPath var3, Map<String, Object> var4);

        abstract void processList(ShiftrCompositeSpec var1, List<Object> var2, WalkedPath var3, Map<String, Object> var4);

        abstract void processScalar(ShiftrCompositeSpec var1, String var2, WalkedPath var3, Map<String, Object> var4);

        private static void applyKeyToLiteralAndComputed(ShiftrCompositeSpec spec, String subKeyStr, Object subInput, WalkedPath walkedPath, Map<String, Object> output) {
            ShiftrSpec literalChild = (ShiftrSpec)spec.literalChildren.get(subKeyStr);
            if (literalChild != null) {
                literalChild.apply(subKeyStr, subInput, walkedPath, output);
            } else {
                ExecutionStrategy.applyKeyToComputed(spec.computedChildren, walkedPath, output, subKeyStr, subInput);
            }
        }

        private static void applyKeyToComputed(List<ShiftrSpec> computedChildren, WalkedPath walkedPath, Map<String, Object> output, String subKeyStr, Object subInput) {
            for (ShiftrSpec computedChild : computedChildren) {
                if (computedChild.apply(subKeyStr, subInput, walkedPath, output)) break;
            }
        }

        public static ExecutionStrategy determineStrategy(Map<String, ShiftrSpec> literalChildren, List<ShiftrSpec> computedChildren) {
            if (computedChildren.isEmpty()) {
                return LITERALS_ONLY;
            }
            if (literalChildren.isEmpty()) {
                return COMPUTED_ONLY;
            }
            for (ShiftrSpec computed : computedChildren) {
                if (!(computed.pathElement instanceof StarPathElement)) {
                    return CONFLICT;
                }
                StarPathElement starPathElement = (StarPathElement)computed.pathElement;
                for (String literal : literalChildren.keySet()) {
                    if (!starPathElement.stringMatch(literal)) continue;
                    return CONFLICT;
                }
            }
            return NO_CONFLICT;
        }
    }
}

