/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.shiftr.spec;

import com.bazaarvoice.jolt.common.WalkedPath;
import com.bazaarvoice.jolt.common.pathelement.AtPathElement;
import com.bazaarvoice.jolt.common.pathelement.DollarPathElement;
import com.bazaarvoice.jolt.common.pathelement.HashPathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.TransposePathElement;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.shiftr.ShiftrWriter;
import com.bazaarvoice.jolt.shiftr.spec.ShiftrSpec;
import com.bazaarvoice.jolt.utils.StringTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ShiftrLeafSpec
extends ShiftrSpec {
    private final List<ShiftrWriter> shiftrWriters;

    public ShiftrLeafSpec(String rawKey, Object rhs) {
        super(rawKey);
        List<Object> writers;
        if (rhs instanceof String) {
            writers = Arrays.asList(ShiftrLeafSpec.parseOutputDotNotation(rhs));
        } else if (rhs instanceof List) {
            List rhsList = (List)rhs;
            writers = new ArrayList(rhsList.size());
            for (Object dotNotation : rhsList) {
                writers.add(ShiftrLeafSpec.parseOutputDotNotation(dotNotation));
            }
        } else if (rhs == null) {
            writers = Collections.emptyList();
        } else {
            throw new SpecException("Invalid Shiftr spec RHS.  Should be map, string, or array of strings.  Spec in question : " + rhs);
        }
        this.shiftrWriters = Collections.unmodifiableList(writers);
    }

    private static ShiftrWriter parseOutputDotNotation(Object rawObj) {
        if (!(rawObj instanceof String)) {
            throw new SpecException("Invalid Shiftr spec, RHS should be a String or array of Strings.   Value in question : " + rawObj);
        }
        String outputPathStr = (String)rawObj;
        outputPathStr = StringTools.isBlank(outputPathStr) ? "root" : "root." + outputPathStr;
        return new ShiftrWriter(outputPathStr);
    }

    @Override
    public boolean apply(String inputKey, Object input, WalkedPath walkedPath, Map<String, Object> output) {
        Object data;
        LiteralPathElement thisLevel = this.pathElement.match(inputKey, walkedPath);
        if (thisLevel == null) {
            return false;
        }
        boolean realChild = false;
        if (this.pathElement instanceof DollarPathElement || this.pathElement instanceof HashPathElement) {
            data = thisLevel.getCanonicalForm();
        } else if (this.pathElement instanceof AtPathElement) {
            data = input;
        } else if (this.pathElement instanceof TransposePathElement) {
            TransposePathElement tpe = (TransposePathElement)this.pathElement;
            data = tpe.objectEvaluate(walkedPath);
            if (data == null) {
                return false;
            }
        } else {
            data = input;
            realChild = true;
        }
        walkedPath.add(input, thisLevel);
        for (ShiftrWriter outputPath : this.shiftrWriters) {
            outputPath.write(data, output, walkedPath);
        }
        walkedPath.removeLast();
        if (realChild) {
            walkedPath.lastElement().getLiteralPathElement().incrementHashCount();
        }
        return realChild;
    }
}

