/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.shiftr.spec;

import com.bazaarvoice.jolt.common.WalkedPath;
import com.bazaarvoice.jolt.common.pathelement.AmpPathElement;
import com.bazaarvoice.jolt.common.pathelement.ArrayPathElement;
import com.bazaarvoice.jolt.common.pathelement.AtPathElement;
import com.bazaarvoice.jolt.common.pathelement.DollarPathElement;
import com.bazaarvoice.jolt.common.pathelement.HashPathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.MatchablePathElement;
import com.bazaarvoice.jolt.common.pathelement.PathElement;
import com.bazaarvoice.jolt.common.pathelement.StarAllPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarDoublePathElement;
import com.bazaarvoice.jolt.common.pathelement.StarRegexPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarSinglePathElement;
import com.bazaarvoice.jolt.common.pathelement.TransposePathElement;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.utils.StringTools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class ShiftrSpec {
    protected final MatchablePathElement pathElement;

    public ShiftrSpec(String rawJsonKey) {
        PathElement pe = ShiftrSpec.parseSingleKeyLHS(rawJsonKey);
        if (!(pe instanceof MatchablePathElement)) {
            throw new SpecException("Spec LHS key=" + rawJsonKey + " is not a valid LHS key.");
        }
        this.pathElement = (MatchablePathElement)pe;
    }

    public static PathElement parseSingleKeyLHS(String key) {
        if ("@".equals(key)) {
            return new AtPathElement(key);
        }
        if ("*".equals(key)) {
            return new StarAllPathElement(key);
        }
        if (key.startsWith("[")) {
            if (StringTools.countMatches(key, "[") != 1 || StringTools.countMatches(key, "]") != 1) {
                throw new SpecException("Invalid key:" + key + " has too many [] references.");
            }
            return new ArrayPathElement(key);
        }
        if (key.startsWith("@") || key.contains("@(")) {
            return TransposePathElement.parse(key);
        }
        if (key.contains("@")) {
            throw new SpecException("Invalid key:" + key + " can not have an @ other than at the front.");
        }
        if (key.contains("$")) {
            return new DollarPathElement(key);
        }
        if (key.contains("[")) {
            if (StringTools.countMatches(key, "[") != 1 || StringTools.countMatches(key, "]") != 1) {
                throw new SpecException("Invalid key:" + key + " has too many [] references.");
            }
            return new ArrayPathElement(key);
        }
        if (key.contains("&")) {
            if (key.contains("*")) {
                throw new SpecException("Can't mix * with & ) ");
            }
            return new AmpPathElement(key);
        }
        if (key.contains("*")) {
            int numOfStars = StringTools.countMatches(key, "*");
            if (numOfStars == 1) {
                return new StarSinglePathElement(key);
            }
            if (numOfStars == 2) {
                return new StarDoublePathElement(key);
            }
            return new StarRegexPathElement(key);
        }
        if (key.contains("#")) {
            return new HashPathElement(key);
        }
        return new LiteralPathElement(key);
    }

    public static Iterator<Character> stringIterator(final String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return new Iterator<Character>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < string.length();
            }

            @Override
            public Character next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Character.valueOf(string.charAt(this.index++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static String fixLeadingBracketSugar(String dotNotaton) {
        if (dotNotaton == null || dotNotaton.length() == 0) {
            return "";
        }
        char prev = dotNotaton.charAt(0);
        StringBuilder sb = new StringBuilder();
        sb.append(prev);
        for (int index = 1; index < dotNotaton.length(); ++index) {
            char curr = dotNotaton.charAt(index);
            if (curr == '[' && prev != '@' && prev != '.') {
                sb.append('.');
            }
            sb.append(curr);
            prev = curr;
        }
        return sb.toString();
    }

    private static String parseAtPathElement(Iterator<Character> iter, String dotNotationRef) {
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isParensAt = false;
        int atParensCount = 0;
        char c = iter.next().charValue();
        if (c == '(') {
            isParensAt = true;
            ++atParensCount;
        } else if (c == '.') {
            throw new SpecException("Unable to parse dotNotation, invalid TransposePathElement : " + dotNotationRef);
        }
        sb.append(c);
        while (iter.hasNext()) {
            c = iter.next().charValue();
            sb.append(c);
            if (isParensAt) {
                if (c == '(') {
                    throw new SpecException("Unable to parse dotNotation, too many open parens '(' : " + dotNotationRef);
                }
                if (c == ')') {
                    --atParensCount;
                }
                if (atParensCount == 0) {
                    return sb.toString();
                }
                if (atParensCount >= 0) continue;
                throw new SpecException("Unable to parse dotNotation, specifically the '@()' part : " + dotNotationRef);
            }
            if (c != '.') continue;
            return "(" + sb.toString().substring(0, sb.length() - 1) + ")";
        }
        if (isParensAt && atParensCount != 0) {
            throw new SpecException("Invalid @() pathElement from : " + dotNotationRef);
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<String> parseDotNotation(List<String> pathStrings, Iterator<Character> iter, String dotNotationRef) {
        if (!iter.hasNext()) {
            return pathStrings;
        }
        boolean escapeActive = false;
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            char c;
            block12: {
                c = iter.next().charValue();
                if (c == '\\') {
                    boolean bl = escapeActive = !escapeActive;
                }
                if (c == '@') {
                    boolean isPartOfArray;
                    sb.append('@');
                    sb.append(ShiftrSpec.parseAtPathElement(iter, dotNotationRef));
                    boolean bl = isPartOfArray = sb.indexOf("[") != -1 && sb.indexOf("]") == -1;
                    if (!isPartOfArray) {
                        pathStrings.add(sb.toString());
                        sb = new StringBuilder();
                    }
                } else {
                    if (c == '.') {
                        if (escapeActive) {
                            sb.append(c);
                            break block12;
                        } else {
                            if (sb.length() != 0) {
                                pathStrings.add(sb.toString());
                            }
                            return ShiftrSpec.parseDotNotation(pathStrings, iter, dotNotationRef);
                        }
                    }
                    if (!escapeActive) {
                        sb.append(c);
                    }
                }
            }
            if (c == '\\') continue;
            escapeActive = false;
        }
        if (sb.length() != 0) {
            pathStrings.add(sb.toString());
        }
        return pathStrings;
    }

    private static List<PathElement> parseList(List<String> keys, String refDotNotation) {
        ArrayList<PathElement> paths = new ArrayList<PathElement>();
        for (String key : keys) {
            PathElement path = ShiftrSpec.parseSingleKeyLHS(key);
            if (path instanceof AtPathElement) {
                throw new SpecException("'.@.' is not valid on the RHS: " + refDotNotation);
            }
            paths.add(path);
        }
        return paths;
    }

    public static List<PathElement> parseDotNotationRHS(String dotNotation) {
        String fixedNotation = ShiftrSpec.fixLeadingBracketSugar(dotNotation);
        List<String> pathStrs = ShiftrSpec.parseDotNotation(new LinkedList<String>(), ShiftrSpec.stringIterator(fixedNotation), dotNotation);
        return ShiftrSpec.parseList(pathStrs, dotNotation);
    }

    public abstract boolean apply(String var1, Object var2, WalkedPath var3, Map<String, Object> var4);
}

