/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.traversr;

import com.bazaarvoice.jolt.traversr.SimpleTraversr;
import java.util.Arrays;
import java.util.List;

public class SimpleTraversal<K> {
    private final SimpleTraversr traversr;
    private final List<String> keys;

    public static <T> SimpleTraversal<T> newTraversal(String humanReadablePath) {
        return new SimpleTraversal(humanReadablePath);
    }

    public SimpleTraversal(String humanReadablePath) {
        this.traversr = new SimpleTraversr(humanReadablePath);
        String[] keysArray = humanReadablePath.split("\\.");
        for (int index = 0; index < keysArray.length; ++index) {
            String key = keysArray[index];
            if (key.charAt(0) != '[' || key.charAt(key.length() - 1) != ']' || key.length() <= 2) continue;
            keysArray[index] = key.substring(1, key.length() - 1);
        }
        this.keys = Arrays.asList(keysArray);
    }

    public K get(Object tree) {
        return (K)this.traversr.get(tree, this.keys);
    }

    public K set(Object tree, K data) {
        return (K)this.traversr.set(tree, this.keys, data);
    }

    public K remove(Object tree) {
        return (K)this.traversr.remove(tree, this.keys);
    }
}

