/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.traversr.traversal;

import com.bazaarvoice.jolt.traversr.Traversr;
import com.bazaarvoice.jolt.traversr.traversal.TraversalStep;
import java.util.Iterator;

public abstract class BaseTraversalStep<T>
implements TraversalStep<T> {
    protected final TraversalStep child;
    protected final Traversr traversr;

    public BaseTraversalStep(Traversr traversr, TraversalStep child) {
        this.traversr = traversr;
        this.child = child;
    }

    @Override
    public TraversalStep getChild() {
        return this.child;
    }

    @Override
    public final Object traverse(Object tree, TraversalStep.Operation op, Iterator<String> keys, Object data) {
        if (tree == null) {
            return null;
        }
        if (this.getStepType().isAssignableFrom(tree.getClass())) {
            String key = keys.next();
            if (this.child == null) {
                switch (op) {
                    case GET: {
                        return this.get(tree, key);
                    }
                    case SET: {
                        return this.traversr.handleFinalSet(this, tree, key, data);
                    }
                    case REMOVE: {
                        return this.remove(tree, key);
                    }
                }
                throw new IllegalStateException("Invalid op:" + op.toString());
            }
            Object sub = this.traversr.handleIntermediateGet(this, tree, key, op);
            return this.child.traverse(sub, op, keys, data);
        }
        return null;
    }
}

