/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.commons.dbcp2;

import com.frameworkset.commons.dbcp2.AbandonedTrace;
import com.frameworkset.commons.dbcp2.DelegatingCallableStatement;
import com.frameworkset.commons.dbcp2.DelegatingConnection;
import com.frameworkset.commons.dbcp2.DelegatingPreparedStatement;
import com.frameworkset.commons.dbcp2.PStmtKey;
import com.frameworkset.commons.pool2.KeyedObjectPool;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PoolableCallableStatement
extends DelegatingCallableStatement {
    private final KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> _pool;
    private final PStmtKey _key;

    public PoolableCallableStatement(CallableStatement stmt, PStmtKey key, KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> pool, DelegatingConnection<Connection> conn) {
        super(conn, stmt);
        this._pool = pool;
        this._key = key;
        if (this.getConnectionInternal() != null) {
            this.getConnectionInternal().removeTrace(this);
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            try {
                this._pool.returnObject(this._key, this);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Cannot close CallableStatement (return to pool failed)", e);
            }
        }
    }

    @Override
    protected void activate() throws SQLException {
        this.setClosedInternal(false);
        if (this.getConnectionInternal() != null) {
            this.getConnectionInternal().addTrace(this);
        }
        super.activate();
    }

    @Override
    protected void passivate() throws SQLException {
        List<AbandonedTrace> resultSets;
        this.setClosedInternal(true);
        if (this.getConnectionInternal() != null) {
            this.getConnectionInternal().removeTrace(this);
        }
        if ((resultSets = this.getTrace()) != null) {
            ResultSet[] set;
            for (ResultSet element : set = resultSets.toArray(new ResultSet[resultSets.size()])) {
                element.close();
            }
            this.clearTrace();
        }
        super.passivate();
    }
}

