/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.commons.dbcp2;

import com.frameworkset.commons.dbcp2.LifetimeExceededException;
import com.frameworkset.commons.dbcp2.Utils;
import com.frameworkset.commons.pool2.SwallowedExceptionListener;
import org.slf4j.Logger;

public class SwallowedExceptionLogger
implements SwallowedExceptionListener {
    private final Logger log;
    private final boolean logExpiredConnections;

    public SwallowedExceptionLogger(Logger log) {
        this(log, true);
    }

    public SwallowedExceptionLogger(Logger log, boolean logExpiredConnections) {
        this.log = log;
        this.logExpiredConnections = logExpiredConnections;
    }

    @Override
    public void onSwallowException(Exception e) {
        if (this.logExpiredConnections || !(e instanceof LifetimeExceededException)) {
            this.log.warn(Utils.getMessage("swallowedExceptionLogger.onSwallowedException"), (Throwable)e);
        }
    }
}

