/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.commons.dbcp2.managed;

import com.frameworkset.commons.dbcp2.DelegatingConnection;
import com.frameworkset.commons.dbcp2.managed.TransactionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

public class TransactionRegistry {
    private final TransactionManager transactionManager;
    private final Map<Transaction, TransactionContext> caches = new WeakHashMap<Transaction, TransactionContext>();
    private final Map<Connection, XAResource> xaResources = new WeakHashMap<Connection, XAResource>();

    public TransactionRegistry(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public synchronized void registerConnection(Connection connection, XAResource xaResource) {
        if (connection == null) {
            throw new NullPointerException("connection is null");
        }
        if (xaResource == null) {
            throw new NullPointerException("xaResource is null");
        }
        this.xaResources.put(connection, xaResource);
    }

    public synchronized XAResource getXAResource(Connection connection) throws SQLException {
        if (connection == null) {
            throw new NullPointerException("connection is null");
        }
        Connection key = this.getConnectionKey(connection);
        XAResource xaResource = this.xaResources.get(key);
        if (xaResource == null) {
            throw new SQLException("Connection does not have a registered XAResource " + connection);
        }
        return xaResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionContext getActiveTransactionContext() throws SQLException {
        Transaction transaction = null;
        try {
            transaction = this.transactionManager.getTransaction();
            if (transaction == null) {
                return null;
            }
            int status = transaction.getStatus();
            if (status != 0 && status != 1) {
                return null;
            }
        }
        catch (SystemException e) {
            throw new SQLException("Unable to determine current transaction ", e);
        }
        TransactionRegistry transactionRegistry = this;
        synchronized (transactionRegistry) {
            TransactionContext cache = this.caches.get(transaction);
            if (cache == null) {
                cache = new TransactionContext(this, transaction);
                this.caches.put(transaction, cache);
            }
            return cache;
        }
    }

    public synchronized void unregisterConnection(Connection connection) {
        Connection key = this.getConnectionKey(connection);
        this.xaResources.remove(key);
    }

    private Connection getConnectionKey(Connection connection) {
        Connection result = connection instanceof DelegatingConnection ? ((DelegatingConnection)connection).getInnermostDelegateInternal() : connection;
        return result;
    }
}

