/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.engine.transform;

import com.frameworkset.orm.engine.EngineException;
import com.frameworkset.orm.engine.model.Column;
import com.frameworkset.orm.engine.model.Database;
import com.frameworkset.orm.engine.model.Domain;
import com.frameworkset.orm.engine.model.ForeignKey;
import com.frameworkset.orm.engine.model.Index;
import com.frameworkset.orm.engine.model.Table;
import com.frameworkset.orm.engine.model.Unique;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToAppData
extends DefaultHandler
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(XmlToAppData.class);
    private Database database;
    private Table currTable;
    private Column currColumn;
    private ForeignKey currFK;
    private Index currIndex;
    private Unique currUnique;
    private boolean firstPass;
    private boolean isExternalSchema;
    private String currentPackage;
    private String currentXmlFile;
    private String defaultPackage;
    private static SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    private Vector alreadyReadFiles;
    private Stack parsingStack = new Stack();

    public XmlToAppData(String databaseType) {
        this.database = new Database(databaseType);
        this.firstPass = true;
    }

    public XmlToAppData(String databaseType, String defaultPackage) {
        this.database = new Database(databaseType);
        this.defaultPackage = defaultPackage;
        this.firstPass = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database parseFile(String xmlFile) throws EngineException {
        try {
            if (!this.firstPass) {
                throw new Error("No more double pass");
            }
            if (this.alreadyReadFiles != null && this.alreadyReadFiles.contains(xmlFile)) {
                return this.database;
            }
            if (this.alreadyReadFiles == null) {
                this.alreadyReadFiles = new Vector(3, 1);
            }
            this.alreadyReadFiles.add(xmlFile);
            this.currentXmlFile = xmlFile;
            SAXParser parser = saxFactory.newSAXParser();
            FileReader fr = null;
            try {
                fr = new FileReader(xmlFile);
            }
            catch (FileNotFoundException fnfe) {
                throw new FileNotFoundException(new File(xmlFile).getAbsolutePath());
            }
            BufferedReader br = new BufferedReader(fr);
            try {
                log.info("Parsing file: '" + new File(xmlFile).getName() + "'");
                InputSource is = new InputSource(br);
                parser.parse(is, (DefaultHandler)this);
            }
            finally {
                br.close();
            }
        }
        catch (Exception e) {
            throw new EngineException(e);
        }
        if (!this.isExternalSchema) {
            this.firstPass = false;
        }
        this.database.doFinalInitialization();
        return this.database;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        try {
            if (rawName.equals("database")) {
                if (this.isExternalSchema) {
                    this.currentPackage = attributes.getValue("package");
                    if (this.currentPackage == null) {
                        this.currentPackage = this.defaultPackage;
                    }
                } else {
                    this.database.loadFromXML(attributes);
                    if (this.database.getPackage() == null) {
                        this.database.setPackage(this.defaultPackage);
                    }
                }
            } else if (rawName.equals("external-schema")) {
                String xmlFile = attributes.getValue("filename");
                if (xmlFile.charAt(0) != '/') {
                    File f = new File(this.currentXmlFile);
                    xmlFile = new File(f.getParent(), xmlFile).getPath();
                }
                ParseStackElement.pushState(this);
                this.isExternalSchema = true;
                this.parseFile(xmlFile);
                ParseStackElement.popState(this);
            } else if (rawName.equals("domain")) {
                Domain domain = new Domain();
                domain.loadFromXML(attributes, this.database.getPlatform());
                this.database.addDomain(domain);
            } else if (rawName.equals("table")) {
                this.currTable = this.database.addTable(attributes);
                if (this.isExternalSchema) {
                    this.currTable.setForReferenceOnly(true);
                    this.currTable.setPackage(this.currentPackage);
                }
            } else if (rawName.equals("column")) {
                this.currColumn = this.currTable.addColumn(attributes);
            } else if (rawName.equals("inheritance")) {
                this.currColumn.addInheritance(attributes);
            } else if (rawName.equals("foreign-key")) {
                this.currFK = this.currTable.addForeignKey(attributes);
            } else if (rawName.equals("reference")) {
                this.currFK.addReference(attributes);
            } else if (rawName.equals("index")) {
                this.currIndex = this.currTable.addIndex(attributes);
            } else if (rawName.equals("index-column")) {
                this.currIndex.addColumn(attributes);
            } else if (rawName.equals("unique")) {
                this.currUnique = this.currTable.addUnique(attributes);
            } else if (rawName.equals("unique-column")) {
                this.currUnique.addColumn(attributes);
            } else if (rawName.equals("id-method-parameter")) {
                this.currTable.addIdMethodParameter(attributes);
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String rawName) {
        if (log.isDebugEnabled()) {
            log.debug("endElement(" + uri + ", " + localName + ", " + rawName + ") called");
        }
    }

    static {
        saxFactory.setValidating(true);
    }

    private static class ParseStackElement {
        private boolean isExternalSchema;
        private String currentPackage;
        private String currentXmlFile;
        private boolean firstPass;

        public ParseStackElement(XmlToAppData parser) {
            this.isExternalSchema = parser.isExternalSchema;
            this.currentPackage = parser.currentPackage;
            this.currentXmlFile = parser.currentXmlFile;
            this.firstPass = parser.firstPass;
            parser.parsingStack.push(this);
        }

        public static void popState(XmlToAppData parser) {
            if (!parser.parsingStack.isEmpty()) {
                ParseStackElement elem = (ParseStackElement)parser.parsingStack.pop();
                parser.isExternalSchema = elem.isExternalSchema;
                parser.currentPackage = elem.currentPackage;
                parser.currentXmlFile = elem.currentXmlFile;
                parser.firstPass = elem.firstPass;
            }
        }

        public static void pushState(XmlToAppData parser) {
            new ParseStackElement(parser);
        }
    }
}

