/** This class file was automatically generated by jASN1 (http://www.beanit.com) */
package com.beanit.josistack.internal.acse.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerBitString;
import com.beanit.jasn1.ber.types.BerObjectIdentifier;
import com.beanit.jasn1.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class AAREApdu implements BerType, Serializable {

  public static final BerTag tag = new BerTag(BerTag.APPLICATION_CLASS, BerTag.CONSTRUCTED, 1);
  private static final long serialVersionUID = 1L;
  public byte[] code = null;
  private BerBitString protocolVersion = null;
  private BerObjectIdentifier applicationContextName = null;
  private AssociateResult result = null;
  private AssociateSourceDiagnostic resultSourceDiagnostic = null;
  private APTitle respondingAPTitle = null;
  private AEQualifier respondingAEQualifier = null;
  private APInvocationIdentifier respondingAPInvocationIdentifier = null;
  private AEInvocationIdentifier respondingAEInvocationIdentifier = null;
  private ACSERequirements responderAcseRequirements = null;
  private MechanismName mechanismName = null;
  private AuthenticationValue respondingAuthenticationValue = null;
  private ApplicationContextNameList applicationContextNameList = null;
  private ImplementationData implementationInformation = null;
  private AssociationInformation userInformation = null;

  public AAREApdu() {}

  public AAREApdu(byte[] code) {
    this.code = code;
  }

  public BerBitString getProtocolVersion() {
    return protocolVersion;
  }

  public void setProtocolVersion(BerBitString protocolVersion) {
    this.protocolVersion = protocolVersion;
  }

  public BerObjectIdentifier getApplicationContextName() {
    return applicationContextName;
  }

  public void setApplicationContextName(BerObjectIdentifier applicationContextName) {
    this.applicationContextName = applicationContextName;
  }

  public AssociateResult getResult() {
    return result;
  }

  public void setResult(AssociateResult result) {
    this.result = result;
  }

  public AssociateSourceDiagnostic getResultSourceDiagnostic() {
    return resultSourceDiagnostic;
  }

  public void setResultSourceDiagnostic(AssociateSourceDiagnostic resultSourceDiagnostic) {
    this.resultSourceDiagnostic = resultSourceDiagnostic;
  }

  public APTitle getRespondingAPTitle() {
    return respondingAPTitle;
  }

  public void setRespondingAPTitle(APTitle respondingAPTitle) {
    this.respondingAPTitle = respondingAPTitle;
  }

  public AEQualifier getRespondingAEQualifier() {
    return respondingAEQualifier;
  }

  public void setRespondingAEQualifier(AEQualifier respondingAEQualifier) {
    this.respondingAEQualifier = respondingAEQualifier;
  }

  public APInvocationIdentifier getRespondingAPInvocationIdentifier() {
    return respondingAPInvocationIdentifier;
  }

  public void setRespondingAPInvocationIdentifier(
      APInvocationIdentifier respondingAPInvocationIdentifier) {
    this.respondingAPInvocationIdentifier = respondingAPInvocationIdentifier;
  }

  public AEInvocationIdentifier getRespondingAEInvocationIdentifier() {
    return respondingAEInvocationIdentifier;
  }

  public void setRespondingAEInvocationIdentifier(
      AEInvocationIdentifier respondingAEInvocationIdentifier) {
    this.respondingAEInvocationIdentifier = respondingAEInvocationIdentifier;
  }

  public ACSERequirements getResponderAcseRequirements() {
    return responderAcseRequirements;
  }

  public void setResponderAcseRequirements(ACSERequirements responderAcseRequirements) {
    this.responderAcseRequirements = responderAcseRequirements;
  }

  public MechanismName getMechanismName() {
    return mechanismName;
  }

  public void setMechanismName(MechanismName mechanismName) {
    this.mechanismName = mechanismName;
  }

  public AuthenticationValue getRespondingAuthenticationValue() {
    return respondingAuthenticationValue;
  }

  public void setRespondingAuthenticationValue(AuthenticationValue respondingAuthenticationValue) {
    this.respondingAuthenticationValue = respondingAuthenticationValue;
  }

  public ApplicationContextNameList getApplicationContextNameList() {
    return applicationContextNameList;
  }

  public void setApplicationContextNameList(ApplicationContextNameList applicationContextNameList) {
    this.applicationContextNameList = applicationContextNameList;
  }

  public ImplementationData getImplementationInformation() {
    return implementationInformation;
  }

  public void setImplementationInformation(ImplementationData implementationInformation) {
    this.implementationInformation = implementationInformation;
  }

  public AssociationInformation getUserInformation() {
    return userInformation;
  }

  public void setUserInformation(AssociationInformation userInformation) {
    this.userInformation = userInformation;
  }

  public int encode(OutputStream reverseOS) throws IOException {
    return encode(reverseOS, true);
  }

  public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

    if (code != null) {
      for (int i = code.length - 1; i >= 0; i--) {
        reverseOS.write(code[i]);
      }
      if (withTag) {
        return tag.encode(reverseOS) + code.length;
      }
      return code.length;
    }

    int codeLength = 0;
    int sublength;

    if (userInformation != null) {
      codeLength += userInformation.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, CONSTRUCTED, 30
      reverseOS.write(0xBE);
      codeLength += 1;
    }

    if (implementationInformation != null) {
      codeLength += implementationInformation.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 29
      reverseOS.write(0x9D);
      codeLength += 1;
    }

    if (applicationContextNameList != null) {
      codeLength += applicationContextNameList.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, CONSTRUCTED, 11
      reverseOS.write(0xAB);
      codeLength += 1;
    }

    if (respondingAuthenticationValue != null) {
      sublength = respondingAuthenticationValue.encode(reverseOS);
      codeLength += sublength;
      codeLength += BerLength.encodeLength(reverseOS, sublength);
      // write tag: CONTEXT_CLASS, CONSTRUCTED, 10
      reverseOS.write(0xAA);
      codeLength += 1;
    }

    if (mechanismName != null) {
      codeLength += mechanismName.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 9
      reverseOS.write(0x89);
      codeLength += 1;
    }

    if (responderAcseRequirements != null) {
      codeLength += responderAcseRequirements.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 8
      reverseOS.write(0x88);
      codeLength += 1;
    }

    if (respondingAEInvocationIdentifier != null) {
      sublength = respondingAEInvocationIdentifier.encode(reverseOS, true);
      codeLength += sublength;
      codeLength += BerLength.encodeLength(reverseOS, sublength);
      // write tag: CONTEXT_CLASS, CONSTRUCTED, 7
      reverseOS.write(0xA7);
      codeLength += 1;
    }

    if (respondingAPInvocationIdentifier != null) {
      sublength = respondingAPInvocationIdentifier.encode(reverseOS, true);
      codeLength += sublength;
      codeLength += BerLength.encodeLength(reverseOS, sublength);
      // write tag: CONTEXT_CLASS, CONSTRUCTED, 6
      reverseOS.write(0xA6);
      codeLength += 1;
    }

    if (respondingAEQualifier != null) {
      sublength = respondingAEQualifier.encode(reverseOS);
      codeLength += sublength;
      codeLength += BerLength.encodeLength(reverseOS, sublength);
      // write tag: CONTEXT_CLASS, CONSTRUCTED, 5
      reverseOS.write(0xA5);
      codeLength += 1;
    }

    if (respondingAPTitle != null) {
      sublength = respondingAPTitle.encode(reverseOS);
      codeLength += sublength;
      codeLength += BerLength.encodeLength(reverseOS, sublength);
      // write tag: CONTEXT_CLASS, CONSTRUCTED, 4
      reverseOS.write(0xA4);
      codeLength += 1;
    }

    sublength = resultSourceDiagnostic.encode(reverseOS);
    codeLength += sublength;
    codeLength += BerLength.encodeLength(reverseOS, sublength);
    // write tag: CONTEXT_CLASS, CONSTRUCTED, 3
    reverseOS.write(0xA3);
    codeLength += 1;

    sublength = result.encode(reverseOS, true);
    codeLength += sublength;
    codeLength += BerLength.encodeLength(reverseOS, sublength);
    // write tag: CONTEXT_CLASS, CONSTRUCTED, 2
    reverseOS.write(0xA2);
    codeLength += 1;

    sublength = applicationContextName.encode(reverseOS, true);
    codeLength += sublength;
    codeLength += BerLength.encodeLength(reverseOS, sublength);
    // write tag: CONTEXT_CLASS, CONSTRUCTED, 1
    reverseOS.write(0xA1);
    codeLength += 1;

    if (protocolVersion != null) {
      codeLength += protocolVersion.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 0
      reverseOS.write(0x80);
      codeLength += 1;
    }

    codeLength += BerLength.encodeLength(reverseOS, codeLength);

    if (withTag) {
      codeLength += tag.encode(reverseOS);
    }

    return codeLength;
  }

  public int decode(InputStream is) throws IOException {
    return decode(is, true);
  }

  public int decode(InputStream is, boolean withTag) throws IOException {
    int codeLength = 0;
    int subCodeLength = 0;
    BerTag berTag = new BerTag();

    if (withTag) {
      codeLength += tag.decodeAndCheck(is);
    }

    BerLength length = new BerLength();
    codeLength += length.decode(is);

    int totalLength = length.val;
    codeLength += totalLength;

    subCodeLength += berTag.decode(is);
    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 0)) {
      protocolVersion = new BerBitString();
      subCodeLength += protocolVersion.decode(is, false);
      subCodeLength += berTag.decode(is);
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 1)) {
      subCodeLength += length.decode(is);
      applicationContextName = new BerObjectIdentifier();
      subCodeLength += applicationContextName.decode(is, true);
      subCodeLength += berTag.decode(is);
    } else {
      throw new IOException("Tag does not match the mandatory sequence element tag.");
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 2)) {
      subCodeLength += length.decode(is);
      result = new AssociateResult();
      subCodeLength += result.decode(is, true);
      subCodeLength += berTag.decode(is);
    } else {
      throw new IOException("Tag does not match the mandatory sequence element tag.");
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 3)) {
      subCodeLength += length.decode(is);
      resultSourceDiagnostic = new AssociateSourceDiagnostic();
      subCodeLength += resultSourceDiagnostic.decode(is, null);
      if (subCodeLength == totalLength) {
        return codeLength;
      }
      subCodeLength += berTag.decode(is);
    } else {
      throw new IOException("Tag does not match the mandatory sequence element tag.");
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 4)) {
      subCodeLength += length.decode(is);
      respondingAPTitle = new APTitle();
      subCodeLength += respondingAPTitle.decode(is, null);
      if (subCodeLength == totalLength) {
        return codeLength;
      }
      subCodeLength += berTag.decode(is);
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 5)) {
      subCodeLength += length.decode(is);
      respondingAEQualifier = new AEQualifier();
      subCodeLength += respondingAEQualifier.decode(is, null);
      if (subCodeLength == totalLength) {
        return codeLength;
      }
      subCodeLength += berTag.decode(is);
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 6)) {
      subCodeLength += length.decode(is);
      respondingAPInvocationIdentifier = new APInvocationIdentifier();
      subCodeLength += respondingAPInvocationIdentifier.decode(is, true);
      if (subCodeLength == totalLength) {
        return codeLength;
      }
      subCodeLength += berTag.decode(is);
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 7)) {
      subCodeLength += length.decode(is);
      respondingAEInvocationIdentifier = new AEInvocationIdentifier();
      subCodeLength += respondingAEInvocationIdentifier.decode(is, true);
      if (subCodeLength == totalLength) {
        return codeLength;
      }
      subCodeLength += berTag.decode(is);
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 8)) {
      responderAcseRequirements = new ACSERequirements();
      subCodeLength += responderAcseRequirements.decode(is, false);
      if (subCodeLength == totalLength) {
        return codeLength;
      }
      subCodeLength += berTag.decode(is);
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 9)) {
      mechanismName = new MechanismName();
      subCodeLength += mechanismName.decode(is, false);
      if (subCodeLength == totalLength) {
        return codeLength;
      }
      subCodeLength += berTag.decode(is);
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 10)) {
      subCodeLength += length.decode(is);
      respondingAuthenticationValue = new AuthenticationValue();
      subCodeLength += respondingAuthenticationValue.decode(is, null);
      if (subCodeLength == totalLength) {
        return codeLength;
      }
      subCodeLength += berTag.decode(is);
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 11)) {
      applicationContextNameList = new ApplicationContextNameList();
      subCodeLength += applicationContextNameList.decode(is, false);
      if (subCodeLength == totalLength) {
        return codeLength;
      }
      subCodeLength += berTag.decode(is);
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 29)) {
      implementationInformation = new ImplementationData();
      subCodeLength += implementationInformation.decode(is, false);
      if (subCodeLength == totalLength) {
        return codeLength;
      }
      subCodeLength += berTag.decode(is);
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 30)) {
      userInformation = new AssociationInformation();
      subCodeLength += userInformation.decode(is, false);
      if (subCodeLength == totalLength) {
        return codeLength;
      }
    }
    throw new IOException(
        "Unexpected end of sequence, length tag: "
            + totalLength
            + ", actual sequence length: "
            + subCodeLength);
  }

  public void encodeAndSave(int encodingSizeGuess) throws IOException {
    ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
    encode(reverseOS, false);
    code = reverseOS.getArray();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder();
    appendAsString(sb, 0);
    return sb.toString();
  }

  public void appendAsString(StringBuilder sb, int indentLevel) {

    sb.append("{");
    boolean firstSelectedElement = true;
    if (protocolVersion != null) {
      sb.append("\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      sb.append("protocolVersion: ").append(protocolVersion);
      firstSelectedElement = false;
    }

    if (!firstSelectedElement) {
      sb.append(",\n");
    }
    for (int i = 0; i < indentLevel + 1; i++) {
      sb.append("\t");
    }
    if (applicationContextName != null) {
      sb.append("applicationContextName: ").append(applicationContextName);
    } else {
      sb.append("applicationContextName: <empty-required-field>");
    }

    sb.append(",\n");
    for (int i = 0; i < indentLevel + 1; i++) {
      sb.append("\t");
    }
    if (result != null) {
      sb.append("result: ").append(result);
    } else {
      sb.append("result: <empty-required-field>");
    }

    sb.append(",\n");
    for (int i = 0; i < indentLevel + 1; i++) {
      sb.append("\t");
    }
    if (resultSourceDiagnostic != null) {
      sb.append("resultSourceDiagnostic: ");
      resultSourceDiagnostic.appendAsString(sb, indentLevel + 1);
    } else {
      sb.append("resultSourceDiagnostic: <empty-required-field>");
    }

    if (respondingAPTitle != null) {
      sb.append(",\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      sb.append("respondingAPTitle: ");
      respondingAPTitle.appendAsString(sb, indentLevel + 1);
    }

    if (respondingAEQualifier != null) {
      sb.append(",\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      sb.append("respondingAEQualifier: ");
      respondingAEQualifier.appendAsString(sb, indentLevel + 1);
    }

    if (respondingAPInvocationIdentifier != null) {
      sb.append(",\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      sb.append("respondingAPInvocationIdentifier: ").append(respondingAPInvocationIdentifier);
    }

    if (respondingAEInvocationIdentifier != null) {
      sb.append(",\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      sb.append("respondingAEInvocationIdentifier: ").append(respondingAEInvocationIdentifier);
    }

    if (responderAcseRequirements != null) {
      sb.append(",\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      sb.append("responderAcseRequirements: ").append(responderAcseRequirements);
    }

    if (mechanismName != null) {
      sb.append(",\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      sb.append("mechanismName: ").append(mechanismName);
    }

    if (respondingAuthenticationValue != null) {
      sb.append(",\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      sb.append("respondingAuthenticationValue: ");
      respondingAuthenticationValue.appendAsString(sb, indentLevel + 1);
    }

    if (applicationContextNameList != null) {
      sb.append(",\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      sb.append("applicationContextNameList: ");
      applicationContextNameList.appendAsString(sb, indentLevel + 1);
    }

    if (implementationInformation != null) {
      sb.append(",\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      sb.append("implementationInformation: ").append(implementationInformation);
    }

    if (userInformation != null) {
      sb.append(",\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      sb.append("userInformation: ");
      userInformation.appendAsString(sb, indentLevel + 1);
    }

    sb.append("\n");
    for (int i = 0; i < indentLevel; i++) {
      sb.append("\t");
    }
    sb.append("}");
  }
}
