/** This class file was automatically generated by jASN1 (http://www.beanit.com) */
package com.beanit.josistack.internal.acse.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerInteger;
import com.beanit.jasn1.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class AssociateSourceDiagnostic implements BerType, Serializable {

  private static final long serialVersionUID = 1L;

  public byte[] code = null;
  private BerInteger acseServiceUser = null;
  private BerInteger acseServiceProvider = null;

  public AssociateSourceDiagnostic() {}

  public AssociateSourceDiagnostic(byte[] code) {
    this.code = code;
  }

  public BerInteger getAcseServiceUser() {
    return acseServiceUser;
  }

  public void setAcseServiceUser(BerInteger acseServiceUser) {
    this.acseServiceUser = acseServiceUser;
  }

  public BerInteger getAcseServiceProvider() {
    return acseServiceProvider;
  }

  public void setAcseServiceProvider(BerInteger acseServiceProvider) {
    this.acseServiceProvider = acseServiceProvider;
  }

  public int encode(OutputStream reverseOS) throws IOException {

    if (code != null) {
      for (int i = code.length - 1; i >= 0; i--) {
        reverseOS.write(code[i]);
      }
      return code.length;
    }

    int codeLength = 0;
    int sublength;

    if (acseServiceProvider != null) {
      sublength = acseServiceProvider.encode(reverseOS, true);
      codeLength += sublength;
      codeLength += BerLength.encodeLength(reverseOS, sublength);
      // write tag: CONTEXT_CLASS, CONSTRUCTED, 2
      reverseOS.write(0xA2);
      codeLength += 1;
      return codeLength;
    }

    if (acseServiceUser != null) {
      sublength = acseServiceUser.encode(reverseOS, true);
      codeLength += sublength;
      codeLength += BerLength.encodeLength(reverseOS, sublength);
      // write tag: CONTEXT_CLASS, CONSTRUCTED, 1
      reverseOS.write(0xA1);
      codeLength += 1;
      return codeLength;
    }

    throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
  }

  public int decode(InputStream is) throws IOException {
    return decode(is, null);
  }

  public int decode(InputStream is, BerTag berTag) throws IOException {

    int codeLength = 0;
    BerTag passedTag = berTag;

    if (berTag == null) {
      berTag = new BerTag();
      codeLength += berTag.decode(is);
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 1)) {
      codeLength += BerLength.skip(is);
      acseServiceUser = new BerInteger();
      codeLength += acseServiceUser.decode(is, true);
      return codeLength;
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 2)) {
      codeLength += BerLength.skip(is);
      acseServiceProvider = new BerInteger();
      codeLength += acseServiceProvider.decode(is, true);
      return codeLength;
    }

    if (passedTag != null) {
      return 0;
    }

    throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
  }

  public void encodeAndSave(int encodingSizeGuess) throws IOException {
    ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
    encode(reverseOS);
    code = reverseOS.getArray();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder();
    appendAsString(sb, 0);
    return sb.toString();
  }

  public void appendAsString(StringBuilder sb, int indentLevel) {

    if (acseServiceUser != null) {
      sb.append("acseServiceUser: ").append(acseServiceUser);
      return;
    }

    if (acseServiceProvider != null) {
      sb.append("acseServiceProvider: ").append(acseServiceProvider);
      return;
    }

    sb.append("<none>");
  }
}
