/** This class file was automatically generated by jASN1 (http://www.beanit.com) */
package com.beanit.josistack.internal.presentation.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class CPType implements BerType, Serializable {

  public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 17);
  private static final long serialVersionUID = 1L;
  public byte[] code = null;
  private ModeSelector modeSelector = null;
  private NormalModeParameters normalModeParameters = null;

  public CPType() {}

  public CPType(byte[] code) {
    this.code = code;
  }

  public ModeSelector getModeSelector() {
    return modeSelector;
  }

  public void setModeSelector(ModeSelector modeSelector) {
    this.modeSelector = modeSelector;
  }

  public NormalModeParameters getNormalModeParameters() {
    return normalModeParameters;
  }

  public void setNormalModeParameters(NormalModeParameters normalModeParameters) {
    this.normalModeParameters = normalModeParameters;
  }

  public int encode(OutputStream reverseOS) throws IOException {
    return encode(reverseOS, true);
  }

  public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

    if (code != null) {
      for (int i = code.length - 1; i >= 0; i--) {
        reverseOS.write(code[i]);
      }
      if (withTag) {
        return tag.encode(reverseOS) + code.length;
      }
      return code.length;
    }

    int codeLength = 0;
    if (normalModeParameters != null) {
      codeLength += normalModeParameters.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, CONSTRUCTED, 2
      reverseOS.write(0xA2);
      codeLength += 1;
    }

    codeLength += modeSelector.encode(reverseOS, false);
    // write tag: CONTEXT_CLASS, CONSTRUCTED, 0
    reverseOS.write(0xA0);
    codeLength += 1;

    codeLength += BerLength.encodeLength(reverseOS, codeLength);

    if (withTag) {
      codeLength += tag.encode(reverseOS);
    }

    return codeLength;
  }

  public int decode(InputStream is) throws IOException {
    return decode(is, true);
  }

  public int decode(InputStream is, boolean withTag) throws IOException {
    int codeLength = 0;
    int subCodeLength = 0;
    BerTag berTag = new BerTag();

    if (withTag) {
      codeLength += tag.decodeAndCheck(is);
    }

    BerLength length = new BerLength();
    codeLength += length.decode(is);

    int totalLength = length.val;
    while (subCodeLength < totalLength) {
      subCodeLength += berTag.decode(is);
      if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 0)) {
        modeSelector = new ModeSelector();
        subCodeLength += modeSelector.decode(is, false);
      } else if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 2)) {
        normalModeParameters = new NormalModeParameters();
        subCodeLength += normalModeParameters.decode(is, false);
      }
    }
    if (subCodeLength != totalLength) {
      throw new IOException(
          "Length of set does not match length tag, length tag: "
              + totalLength
              + ", actual set length: "
              + subCodeLength);
    }
    codeLength += subCodeLength;

    return codeLength;
  }

  public void encodeAndSave(int encodingSizeGuess) throws IOException {
    ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
    encode(reverseOS, false);
    code = reverseOS.getArray();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder();
    appendAsString(sb, 0);
    return sb.toString();
  }

  public void appendAsString(StringBuilder sb, int indentLevel) {

    sb.append("{");
    sb.append("\n");
    for (int i = 0; i < indentLevel + 1; i++) {
      sb.append("\t");
    }
    if (modeSelector != null) {
      sb.append("modeSelector: ");
      modeSelector.appendAsString(sb, indentLevel + 1);
    } else {
      sb.append("modeSelector: <empty-required-field>");
    }

    if (normalModeParameters != null) {
      sb.append(",\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      sb.append("normalModeParameters: ");
      normalModeParameters.appendAsString(sb, indentLevel + 1);
    }

    sb.append("\n");
    for (int i = 0; i < indentLevel; i++) {
      sb.append("\t");
    }
    sb.append("}");
  }

  public static class NormalModeParameters implements BerType, Serializable {

    public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private ProtocolVersion protocolVersion = null;
    private CallingPresentationSelector callingPresentationSelector = null;
    private CalledPresentationSelector calledPresentationSelector = null;
    private PresentationContextDefinitionList presentationContextDefinitionList = null;
    private DefaultContextName defaultContextName = null;
    private PresentationRequirements presentationRequirements = null;
    private UserSessionRequirements userSessionRequirements = null;
    private UserData userData = null;

    public NormalModeParameters() {}

    public NormalModeParameters(byte[] code) {
      this.code = code;
    }

    public ProtocolVersion getProtocolVersion() {
      return protocolVersion;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
      this.protocolVersion = protocolVersion;
    }

    public CallingPresentationSelector getCallingPresentationSelector() {
      return callingPresentationSelector;
    }

    public void setCallingPresentationSelector(
        CallingPresentationSelector callingPresentationSelector) {
      this.callingPresentationSelector = callingPresentationSelector;
    }

    public CalledPresentationSelector getCalledPresentationSelector() {
      return calledPresentationSelector;
    }

    public void setCalledPresentationSelector(
        CalledPresentationSelector calledPresentationSelector) {
      this.calledPresentationSelector = calledPresentationSelector;
    }

    public PresentationContextDefinitionList getPresentationContextDefinitionList() {
      return presentationContextDefinitionList;
    }

    public void setPresentationContextDefinitionList(
        PresentationContextDefinitionList presentationContextDefinitionList) {
      this.presentationContextDefinitionList = presentationContextDefinitionList;
    }

    public DefaultContextName getDefaultContextName() {
      return defaultContextName;
    }

    public void setDefaultContextName(DefaultContextName defaultContextName) {
      this.defaultContextName = defaultContextName;
    }

    public PresentationRequirements getPresentationRequirements() {
      return presentationRequirements;
    }

    public void setPresentationRequirements(PresentationRequirements presentationRequirements) {
      this.presentationRequirements = presentationRequirements;
    }

    public UserSessionRequirements getUserSessionRequirements() {
      return userSessionRequirements;
    }

    public void setUserSessionRequirements(UserSessionRequirements userSessionRequirements) {
      this.userSessionRequirements = userSessionRequirements;
    }

    public UserData getUserData() {
      return userData;
    }

    public void setUserData(UserData userData) {
      this.userData = userData;
    }

    public int encode(OutputStream reverseOS) throws IOException {
      return encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

      if (code != null) {
        for (int i = code.length - 1; i >= 0; i--) {
          reverseOS.write(code[i]);
        }
        if (withTag) {
          return tag.encode(reverseOS) + code.length;
        }
        return code.length;
      }

      int codeLength = 0;
      if (userData != null) {
        codeLength += userData.encode(reverseOS);
      }

      if (userSessionRequirements != null) {
        codeLength += userSessionRequirements.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 9
        reverseOS.write(0x89);
        codeLength += 1;
      }

      if (presentationRequirements != null) {
        codeLength += presentationRequirements.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 8
        reverseOS.write(0x88);
        codeLength += 1;
      }

      if (defaultContextName != null) {
        codeLength += defaultContextName.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, CONSTRUCTED, 6
        reverseOS.write(0xA6);
        codeLength += 1;
      }

      if (presentationContextDefinitionList != null) {
        codeLength += presentationContextDefinitionList.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, CONSTRUCTED, 4
        reverseOS.write(0xA4);
        codeLength += 1;
      }

      if (calledPresentationSelector != null) {
        codeLength += calledPresentationSelector.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 2
        reverseOS.write(0x82);
        codeLength += 1;
      }

      if (callingPresentationSelector != null) {
        codeLength += callingPresentationSelector.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 1
        reverseOS.write(0x81);
        codeLength += 1;
      }

      if (protocolVersion != null) {
        codeLength += protocolVersion.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 0
        reverseOS.write(0x80);
        codeLength += 1;
      }

      codeLength += BerLength.encodeLength(reverseOS, codeLength);

      if (withTag) {
        codeLength += tag.encode(reverseOS);
      }

      return codeLength;
    }

    public int decode(InputStream is) throws IOException {
      return decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
      int codeLength = 0;
      int subCodeLength = 0;
      BerTag berTag = new BerTag();

      if (withTag) {
        codeLength += tag.decodeAndCheck(is);
      }

      BerLength length = new BerLength();
      codeLength += length.decode(is);

      int totalLength = length.val;
      codeLength += totalLength;

      if (totalLength == 0) {
        return codeLength;
      }
      subCodeLength += berTag.decode(is);
      if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 0)) {
        protocolVersion = new ProtocolVersion();
        subCodeLength += protocolVersion.decode(is, false);
        if (subCodeLength == totalLength) {
          return codeLength;
        }
        subCodeLength += berTag.decode(is);
      }

      if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 1)) {
        callingPresentationSelector = new CallingPresentationSelector();
        subCodeLength += callingPresentationSelector.decode(is, false);
        if (subCodeLength == totalLength) {
          return codeLength;
        }
        subCodeLength += berTag.decode(is);
      }

      if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 2)) {
        calledPresentationSelector = new CalledPresentationSelector();
        subCodeLength += calledPresentationSelector.decode(is, false);
        if (subCodeLength == totalLength) {
          return codeLength;
        }
        subCodeLength += berTag.decode(is);
      }

      if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 4)) {
        presentationContextDefinitionList = new PresentationContextDefinitionList();
        subCodeLength += presentationContextDefinitionList.decode(is, false);
        if (subCodeLength == totalLength) {
          return codeLength;
        }
        subCodeLength += berTag.decode(is);
      }

      if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 6)) {
        defaultContextName = new DefaultContextName();
        subCodeLength += defaultContextName.decode(is, false);
        if (subCodeLength == totalLength) {
          return codeLength;
        }
        subCodeLength += berTag.decode(is);
      }

      if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 8)) {
        presentationRequirements = new PresentationRequirements();
        subCodeLength += presentationRequirements.decode(is, false);
        if (subCodeLength == totalLength) {
          return codeLength;
        }
        subCodeLength += berTag.decode(is);
      }

      if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 9)) {
        userSessionRequirements = new UserSessionRequirements();
        subCodeLength += userSessionRequirements.decode(is, false);
        if (subCodeLength == totalLength) {
          return codeLength;
        }
        subCodeLength += berTag.decode(is);
      }

      userData = new UserData();
      int choiceDecodeLength = userData.decode(is, berTag);
      subCodeLength += choiceDecodeLength;
      if (subCodeLength == totalLength) {
        return codeLength;
      }
      throw new IOException(
          "Unexpected end of sequence, length tag: "
              + totalLength
              + ", actual sequence length: "
              + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
      ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
      encode(reverseOS, false);
      code = reverseOS.getArray();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder();
      appendAsString(sb, 0);
      return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {

      sb.append("{");
      boolean firstSelectedElement = true;
      if (protocolVersion != null) {
        sb.append("\n");
        for (int i = 0; i < indentLevel + 1; i++) {
          sb.append("\t");
        }
        sb.append("protocolVersion: ").append(protocolVersion);
        firstSelectedElement = false;
      }

      if (callingPresentationSelector != null) {
        if (!firstSelectedElement) {
          sb.append(",\n");
        }
        for (int i = 0; i < indentLevel + 1; i++) {
          sb.append("\t");
        }
        sb.append("callingPresentationSelector: ").append(callingPresentationSelector);
        firstSelectedElement = false;
      }

      if (calledPresentationSelector != null) {
        if (!firstSelectedElement) {
          sb.append(",\n");
        }
        for (int i = 0; i < indentLevel + 1; i++) {
          sb.append("\t");
        }
        sb.append("calledPresentationSelector: ").append(calledPresentationSelector);
        firstSelectedElement = false;
      }

      if (presentationContextDefinitionList != null) {
        if (!firstSelectedElement) {
          sb.append(",\n");
        }
        for (int i = 0; i < indentLevel + 1; i++) {
          sb.append("\t");
        }
        sb.append("presentationContextDefinitionList: ");
        presentationContextDefinitionList.appendAsString(sb, indentLevel + 1);
        firstSelectedElement = false;
      }

      if (defaultContextName != null) {
        if (!firstSelectedElement) {
          sb.append(",\n");
        }
        for (int i = 0; i < indentLevel + 1; i++) {
          sb.append("\t");
        }
        sb.append("defaultContextName: ");
        defaultContextName.appendAsString(sb, indentLevel + 1);
        firstSelectedElement = false;
      }

      if (presentationRequirements != null) {
        if (!firstSelectedElement) {
          sb.append(",\n");
        }
        for (int i = 0; i < indentLevel + 1; i++) {
          sb.append("\t");
        }
        sb.append("presentationRequirements: ").append(presentationRequirements);
        firstSelectedElement = false;
      }

      if (userSessionRequirements != null) {
        if (!firstSelectedElement) {
          sb.append(",\n");
        }
        for (int i = 0; i < indentLevel + 1; i++) {
          sb.append("\t");
        }
        sb.append("userSessionRequirements: ").append(userSessionRequirements);
        firstSelectedElement = false;
      }

      if (userData != null) {
        if (!firstSelectedElement) {
          sb.append(",\n");
        }
        for (int i = 0; i < indentLevel + 1; i++) {
          sb.append("\t");
        }
        sb.append("userData: ");
        userData.appendAsString(sb, indentLevel + 1);
        firstSelectedElement = false;
      }

      sb.append("\n");
      for (int i = 0; i < indentLevel; i++) {
        sb.append("\t");
      }
      sb.append("}");
    }
  }
}
