/** This class file was automatically generated by jASN1 (http://www.beanit.com) */
package com.beanit.josistack.internal.presentation.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerInteger;
import com.beanit.jasn1.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ResultList implements BerType, Serializable {

  public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
  private static final long serialVersionUID = 1L;
  public byte[] code = null;
  private List<SEQUENCE> seqOf = null;

  public ResultList() {
    seqOf = new ArrayList<SEQUENCE>();
  }

  public ResultList(byte[] code) {
    this.code = code;
  }

  public List<SEQUENCE> getSEQUENCE() {
    if (seqOf == null) {
      seqOf = new ArrayList<SEQUENCE>();
    }
    return seqOf;
  }

  public int encode(OutputStream reverseOS) throws IOException {
    return encode(reverseOS, true);
  }

  public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

    if (code != null) {
      for (int i = code.length - 1; i >= 0; i--) {
        reverseOS.write(code[i]);
      }
      if (withTag) {
        return tag.encode(reverseOS) + code.length;
      }
      return code.length;
    }

    int codeLength = 0;
    for (int i = (seqOf.size() - 1); i >= 0; i--) {
      codeLength += seqOf.get(i).encode(reverseOS, true);
    }

    codeLength += BerLength.encodeLength(reverseOS, codeLength);

    if (withTag) {
      codeLength += tag.encode(reverseOS);
    }

    return codeLength;
  }

  public int decode(InputStream is) throws IOException {
    return decode(is, true);
  }

  public int decode(InputStream is, boolean withTag) throws IOException {
    int codeLength = 0;
    int subCodeLength = 0;
    if (withTag) {
      codeLength += tag.decodeAndCheck(is);
    }

    BerLength length = new BerLength();
    codeLength += length.decode(is);
    int totalLength = length.val;

    while (subCodeLength < totalLength) {
      SEQUENCE element = new SEQUENCE();
      subCodeLength += element.decode(is, true);
      seqOf.add(element);
    }
    if (subCodeLength != totalLength) {
      throw new IOException(
          "Decoded SequenceOf or SetOf has wrong length. Expected "
              + totalLength
              + " but has "
              + subCodeLength);
    }
    codeLength += subCodeLength;

    return codeLength;
  }

  public void encodeAndSave(int encodingSizeGuess) throws IOException {
    ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
    encode(reverseOS, false);
    code = reverseOS.getArray();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder();
    appendAsString(sb, 0);
    return sb.toString();
  }

  public void appendAsString(StringBuilder sb, int indentLevel) {

    sb.append("{\n");
    for (int i = 0; i < indentLevel + 1; i++) {
      sb.append("\t");
    }
    if (seqOf == null) {
      sb.append("null");
    } else {
      Iterator<SEQUENCE> it = seqOf.iterator();
      if (it.hasNext()) {
        it.next().appendAsString(sb, indentLevel + 1);
        while (it.hasNext()) {
          sb.append(",\n");
          for (int i = 0; i < indentLevel + 1; i++) {
            sb.append("\t");
          }
          it.next().appendAsString(sb, indentLevel + 1);
        }
      }
    }

    sb.append("\n");
    for (int i = 0; i < indentLevel; i++) {
      sb.append("\t");
    }
    sb.append("}");
  }

  public static class SEQUENCE implements BerType, Serializable {

    public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private Result result = null;
    private TransferSyntaxName transferSyntaxName = null;
    private BerInteger providerReason = null;

    public SEQUENCE() {}

    public SEQUENCE(byte[] code) {
      this.code = code;
    }

    public Result getResult() {
      return result;
    }

    public void setResult(Result result) {
      this.result = result;
    }

    public TransferSyntaxName getTransferSyntaxName() {
      return transferSyntaxName;
    }

    public void setTransferSyntaxName(TransferSyntaxName transferSyntaxName) {
      this.transferSyntaxName = transferSyntaxName;
    }

    public BerInteger getProviderReason() {
      return providerReason;
    }

    public void setProviderReason(BerInteger providerReason) {
      this.providerReason = providerReason;
    }

    public int encode(OutputStream reverseOS) throws IOException {
      return encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

      if (code != null) {
        for (int i = code.length - 1; i >= 0; i--) {
          reverseOS.write(code[i]);
        }
        if (withTag) {
          return tag.encode(reverseOS) + code.length;
        }
        return code.length;
      }

      int codeLength = 0;
      if (providerReason != null) {
        codeLength += providerReason.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 2
        reverseOS.write(0x82);
        codeLength += 1;
      }

      if (transferSyntaxName != null) {
        codeLength += transferSyntaxName.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 1
        reverseOS.write(0x81);
        codeLength += 1;
      }

      codeLength += result.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 0
      reverseOS.write(0x80);
      codeLength += 1;

      codeLength += BerLength.encodeLength(reverseOS, codeLength);

      if (withTag) {
        codeLength += tag.encode(reverseOS);
      }

      return codeLength;
    }

    public int decode(InputStream is) throws IOException {
      return decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
      int codeLength = 0;
      int subCodeLength = 0;
      BerTag berTag = new BerTag();

      if (withTag) {
        codeLength += tag.decodeAndCheck(is);
      }

      BerLength length = new BerLength();
      codeLength += length.decode(is);

      int totalLength = length.val;
      codeLength += totalLength;

      subCodeLength += berTag.decode(is);
      if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 0)) {
        result = new Result();
        subCodeLength += result.decode(is, false);
        if (subCodeLength == totalLength) {
          return codeLength;
        }
        subCodeLength += berTag.decode(is);
      } else {
        throw new IOException("Tag does not match the mandatory sequence element tag.");
      }

      if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 1)) {
        transferSyntaxName = new TransferSyntaxName();
        subCodeLength += transferSyntaxName.decode(is, false);
        if (subCodeLength == totalLength) {
          return codeLength;
        }
        subCodeLength += berTag.decode(is);
      }

      if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 2)) {
        providerReason = new BerInteger();
        subCodeLength += providerReason.decode(is, false);
        if (subCodeLength == totalLength) {
          return codeLength;
        }
      }
      throw new IOException(
          "Unexpected end of sequence, length tag: "
              + totalLength
              + ", actual sequence length: "
              + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
      ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
      encode(reverseOS, false);
      code = reverseOS.getArray();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder();
      appendAsString(sb, 0);
      return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {

      sb.append("{");
      sb.append("\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      if (result != null) {
        sb.append("result: ").append(result);
      } else {
        sb.append("result: <empty-required-field>");
      }

      if (transferSyntaxName != null) {
        sb.append(",\n");
        for (int i = 0; i < indentLevel + 1; i++) {
          sb.append("\t");
        }
        sb.append("transferSyntaxName: ").append(transferSyntaxName);
      }

      if (providerReason != null) {
        sb.append(",\n");
        for (int i = 0; i < indentLevel + 1; i++) {
          sb.append("\t");
        }
        sb.append("providerReason: ").append(providerReason);
      }

      sb.append("\n");
      for (int i = 0; i < indentLevel; i++) {
        sb.append("\t");
      }
      sb.append("}");
    }
  }
}
