/*
 * Copyright 2011 The OpenIEC61850 Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package com.beanit.openiec61850;

/** Callback handler for GetFile service */
public interface GetFileListener {
  /**
   * Is called when a new block of file data is received
   *
   * @param fileData block of file data received
   * @param moreFollows true if more data blocks will follow, false otherwise
   * @return true to continue the GetFile service, false to cancel
   */
  boolean dataReceived(byte[] fileData, boolean moreFollows);
}
