/** This class file was automatically generated by jASN1 (http://www.beanit.com) */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerBitString;
import com.beanit.jasn1.ber.types.BerInteger;
import com.beanit.jasn1.ber.types.BerOctetString;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.jasn1.ber.types.string.BerVisibleString;
import com.beanit.openiec61850.internal.BerBoolean;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Data implements BerType, Serializable {

  private static final long serialVersionUID = 1L;

  public byte[] code = null;
  private Array array = null;
  private Structure structure = null;
  private BerBoolean bool = null;
  private BerBitString bitString = null;
  private BerInteger integer = null;
  private BerInteger unsigned = null;
  private FloatingPoint floatingPoint = null;
  private BerOctetString octetString = null;
  private BerVisibleString visibleString = null;
  private TimeOfDay binaryTime = null;
  private MMSString mMSString = null;
  private UtcTime utcTime = null;

  public Data() {}

  public Data(byte[] code) {
    this.code = code;
  }

  public Array getArray() {
    return array;
  }

  public void setArray(Array array) {
    this.array = array;
  }

  public Structure getStructure() {
    return structure;
  }

  public void setStructure(Structure structure) {
    this.structure = structure;
  }

  public BerBoolean getBool() {
    return bool;
  }

  public void setBool(BerBoolean bool) {
    this.bool = bool;
  }

  public BerBitString getBitString() {
    return bitString;
  }

  public void setBitString(BerBitString bitString) {
    this.bitString = bitString;
  }

  public BerInteger getInteger() {
    return integer;
  }

  public void setInteger(BerInteger integer) {
    this.integer = integer;
  }

  public BerInteger getUnsigned() {
    return unsigned;
  }

  public void setUnsigned(BerInteger unsigned) {
    this.unsigned = unsigned;
  }

  public FloatingPoint getFloatingPoint() {
    return floatingPoint;
  }

  public void setFloatingPoint(FloatingPoint floatingPoint) {
    this.floatingPoint = floatingPoint;
  }

  public BerOctetString getOctetString() {
    return octetString;
  }

  public void setOctetString(BerOctetString octetString) {
    this.octetString = octetString;
  }

  public BerVisibleString getVisibleString() {
    return visibleString;
  }

  public void setVisibleString(BerVisibleString visibleString) {
    this.visibleString = visibleString;
  }

  public TimeOfDay getBinaryTime() {
    return binaryTime;
  }

  public void setBinaryTime(TimeOfDay binaryTime) {
    this.binaryTime = binaryTime;
  }

  public MMSString getMMSString() {
    return mMSString;
  }

  public void setMMSString(MMSString mMSString) {
    this.mMSString = mMSString;
  }

  public UtcTime getUtcTime() {
    return utcTime;
  }

  public void setUtcTime(UtcTime utcTime) {
    this.utcTime = utcTime;
  }

  public int encode(OutputStream reverseOS) throws IOException {

    if (code != null) {
      for (int i = code.length - 1; i >= 0; i--) {
        reverseOS.write(code[i]);
      }
      return code.length;
    }

    int codeLength = 0;
    if (utcTime != null) {
      codeLength += utcTime.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 17
      reverseOS.write(0x91);
      codeLength += 1;
      return codeLength;
    }

    if (mMSString != null) {
      codeLength += mMSString.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 16
      reverseOS.write(0x90);
      codeLength += 1;
      return codeLength;
    }

    if (binaryTime != null) {
      codeLength += binaryTime.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 12
      reverseOS.write(0x8C);
      codeLength += 1;
      return codeLength;
    }

    if (visibleString != null) {
      codeLength += visibleString.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 10
      reverseOS.write(0x8A);
      codeLength += 1;
      return codeLength;
    }

    if (octetString != null) {
      codeLength += octetString.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 9
      reverseOS.write(0x89);
      codeLength += 1;
      return codeLength;
    }

    if (floatingPoint != null) {
      codeLength += floatingPoint.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 7
      reverseOS.write(0x87);
      codeLength += 1;
      return codeLength;
    }

    if (unsigned != null) {
      codeLength += unsigned.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 6
      reverseOS.write(0x86);
      codeLength += 1;
      return codeLength;
    }

    if (integer != null) {
      codeLength += integer.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 5
      reverseOS.write(0x85);
      codeLength += 1;
      return codeLength;
    }

    if (bitString != null) {
      codeLength += bitString.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 4
      reverseOS.write(0x84);
      codeLength += 1;
      return codeLength;
    }

    if (bool != null) {
      codeLength += bool.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 3
      reverseOS.write(0x83);
      codeLength += 1;
      return codeLength;
    }

    if (structure != null) {
      codeLength += structure.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, CONSTRUCTED, 2
      reverseOS.write(0xA2);
      codeLength += 1;
      return codeLength;
    }

    if (array != null) {
      codeLength += array.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, CONSTRUCTED, 1
      reverseOS.write(0xA1);
      codeLength += 1;
      return codeLength;
    }

    throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
  }

  public int decode(InputStream is) throws IOException {
    return decode(is, null);
  }

  public int decode(InputStream is, BerTag berTag) throws IOException {

    int codeLength = 0;
    BerTag passedTag = berTag;

    if (berTag == null) {
      berTag = new BerTag();
      codeLength += berTag.decode(is);
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 1)) {
      array = new Array();
      codeLength += array.decode(is, false);
      return codeLength;
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 2)) {
      structure = new Structure();
      codeLength += structure.decode(is, false);
      return codeLength;
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 3)) {
      bool = new BerBoolean();
      codeLength += bool.decode(is, false);
      return codeLength;
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 4)) {
      bitString = new BerBitString();
      codeLength += bitString.decode(is, false);
      return codeLength;
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 5)) {
      integer = new BerInteger();
      codeLength += integer.decode(is, false);
      return codeLength;
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 6)) {
      unsigned = new BerInteger();
      codeLength += unsigned.decode(is, false);
      return codeLength;
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 7)) {
      floatingPoint = new FloatingPoint();
      codeLength += floatingPoint.decode(is, false);
      return codeLength;
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 9)) {
      octetString = new BerOctetString();
      codeLength += octetString.decode(is, false);
      return codeLength;
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 10)) {
      visibleString = new BerVisibleString();
      codeLength += visibleString.decode(is, false);
      return codeLength;
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 12)) {
      binaryTime = new TimeOfDay();
      codeLength += binaryTime.decode(is, false);
      return codeLength;
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 16)) {
      mMSString = new MMSString();
      codeLength += mMSString.decode(is, false);
      return codeLength;
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 17)) {
      utcTime = new UtcTime();
      codeLength += utcTime.decode(is, false);
      return codeLength;
    }

    if (passedTag != null) {
      return 0;
    }

    throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
  }

  public void encodeAndSave(int encodingSizeGuess) throws IOException {
    ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
    encode(reverseOS);
    code = reverseOS.getArray();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder();
    appendAsString(sb, 0);
    return sb.toString();
  }

  public void appendAsString(StringBuilder sb, int indentLevel) {

    if (array != null) {
      sb.append("array: ");
      array.appendAsString(sb, indentLevel + 1);
      return;
    }

    if (structure != null) {
      sb.append("structure: ");
      structure.appendAsString(sb, indentLevel + 1);
      return;
    }

    if (bool != null) {
      sb.append("bool: ").append(bool);
      return;
    }

    if (bitString != null) {
      sb.append("bitString: ").append(bitString);
      return;
    }

    if (integer != null) {
      sb.append("integer: ").append(integer);
      return;
    }

    if (unsigned != null) {
      sb.append("unsigned: ").append(unsigned);
      return;
    }

    if (floatingPoint != null) {
      sb.append("floatingPoint: ").append(floatingPoint);
      return;
    }

    if (octetString != null) {
      sb.append("octetString: ").append(octetString);
      return;
    }

    if (visibleString != null) {
      sb.append("visibleString: ").append(visibleString);
      return;
    }

    if (binaryTime != null) {
      sb.append("binaryTime: ").append(binaryTime);
      return;
    }

    if (mMSString != null) {
      sb.append("mMSString: ").append(mMSString);
      return;
    }

    if (utcTime != null) {
      sb.append("utcTime: ").append(utcTime);
      return;
    }

    sb.append("<none>");
  }

  public static class Array implements BerType, Serializable {

    public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private List<Data> seqOf = null;

    public Array() {
      seqOf = new ArrayList<Data>();
    }

    public Array(byte[] code) {
      this.code = code;
    }

    public List<Data> getData() {
      if (seqOf == null) {
        seqOf = new ArrayList<Data>();
      }
      return seqOf;
    }

    public int encode(OutputStream reverseOS) throws IOException {
      return encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

      if (code != null) {
        for (int i = code.length - 1; i >= 0; i--) {
          reverseOS.write(code[i]);
        }
        if (withTag) {
          return tag.encode(reverseOS) + code.length;
        }
        return code.length;
      }

      int codeLength = 0;
      for (int i = (seqOf.size() - 1); i >= 0; i--) {
        codeLength += seqOf.get(i).encode(reverseOS);
      }

      codeLength += BerLength.encodeLength(reverseOS, codeLength);

      if (withTag) {
        codeLength += tag.encode(reverseOS);
      }

      return codeLength;
    }

    public int decode(InputStream is) throws IOException {
      return decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
      int codeLength = 0;
      int subCodeLength = 0;
      if (withTag) {
        codeLength += tag.decodeAndCheck(is);
      }

      BerLength length = new BerLength();
      codeLength += length.decode(is);
      int totalLength = length.val;

      while (subCodeLength < totalLength) {
        Data element = new Data();
        subCodeLength += element.decode(is, null);
        seqOf.add(element);
      }
      if (subCodeLength != totalLength) {
        throw new IOException(
            "Decoded SequenceOf or SetOf has wrong length. Expected "
                + totalLength
                + " but has "
                + subCodeLength);
      }
      codeLength += subCodeLength;

      return codeLength;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
      ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
      encode(reverseOS, false);
      code = reverseOS.getArray();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder();
      appendAsString(sb, 0);
      return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {

      sb.append("{\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      if (seqOf == null) {
        sb.append("null");
      } else {
        Iterator<Data> it = seqOf.iterator();
        if (it.hasNext()) {
          it.next().appendAsString(sb, indentLevel + 1);
          while (it.hasNext()) {
            sb.append(",\n");
            for (int i = 0; i < indentLevel + 1; i++) {
              sb.append("\t");
            }
            it.next().appendAsString(sb, indentLevel + 1);
          }
        }
      }

      sb.append("\n");
      for (int i = 0; i < indentLevel; i++) {
        sb.append("\t");
      }
      sb.append("}");
    }
  }

  public static class Structure implements BerType, Serializable {

    public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private List<Data> seqOf = null;

    public Structure() {
      seqOf = new ArrayList<Data>();
    }

    public Structure(byte[] code) {
      this.code = code;
    }

    public List<Data> getData() {
      if (seqOf == null) {
        seqOf = new ArrayList<Data>();
      }
      return seqOf;
    }

    public int encode(OutputStream reverseOS) throws IOException {
      return encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

      if (code != null) {
        for (int i = code.length - 1; i >= 0; i--) {
          reverseOS.write(code[i]);
        }
        if (withTag) {
          return tag.encode(reverseOS) + code.length;
        }
        return code.length;
      }

      int codeLength = 0;
      for (int i = (seqOf.size() - 1); i >= 0; i--) {
        codeLength += seqOf.get(i).encode(reverseOS);
      }

      codeLength += BerLength.encodeLength(reverseOS, codeLength);

      if (withTag) {
        codeLength += tag.encode(reverseOS);
      }

      return codeLength;
    }

    public int decode(InputStream is) throws IOException {
      return decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
      int codeLength = 0;
      int subCodeLength = 0;
      if (withTag) {
        codeLength += tag.decodeAndCheck(is);
      }

      BerLength length = new BerLength();
      codeLength += length.decode(is);
      int totalLength = length.val;

      while (subCodeLength < totalLength) {
        Data element = new Data();
        subCodeLength += element.decode(is, null);
        seqOf.add(element);
      }
      if (subCodeLength != totalLength) {
        throw new IOException(
            "Decoded SequenceOf or SetOf has wrong length. Expected "
                + totalLength
                + " but has "
                + subCodeLength);
      }
      codeLength += subCodeLength;

      return codeLength;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
      ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
      encode(reverseOS, false);
      code = reverseOS.getArray();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder();
      appendAsString(sb, 0);
      return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {

      sb.append("{\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      if (seqOf == null) {
        sb.append("null");
      } else {
        Iterator<Data> it = seqOf.iterator();
        if (it.hasNext()) {
          it.next().appendAsString(sb, indentLevel + 1);
          while (it.hasNext()) {
            sb.append(",\n");
            for (int i = 0; i < indentLevel + 1; i++) {
              sb.append("\t");
            }
            it.next().appendAsString(sb, indentLevel + 1);
          }
        }
      }

      sb.append("\n");
      for (int i = 0; i < indentLevel; i++) {
        sb.append("\t");
      }
      sb.append("}");
    }
  }
}
