/** This class file was automatically generated by jASN1 (http://www.beanit.com) */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class ObjectName implements BerType, Serializable {

  private static final long serialVersionUID = 1L;

  public byte[] code = null;
  private Identifier vmdSpecific = null;
  private DomainSpecific domainSpecific = null;
  private Identifier aaSpecific = null;

  public ObjectName() {}

  public ObjectName(byte[] code) {
    this.code = code;
  }

  public Identifier getVmdSpecific() {
    return vmdSpecific;
  }

  public void setVmdSpecific(Identifier vmdSpecific) {
    this.vmdSpecific = vmdSpecific;
  }

  public DomainSpecific getDomainSpecific() {
    return domainSpecific;
  }

  public void setDomainSpecific(DomainSpecific domainSpecific) {
    this.domainSpecific = domainSpecific;
  }

  public Identifier getAaSpecific() {
    return aaSpecific;
  }

  public void setAaSpecific(Identifier aaSpecific) {
    this.aaSpecific = aaSpecific;
  }

  public int encode(OutputStream reverseOS) throws IOException {

    if (code != null) {
      for (int i = code.length - 1; i >= 0; i--) {
        reverseOS.write(code[i]);
      }
      return code.length;
    }

    int codeLength = 0;
    if (aaSpecific != null) {
      codeLength += aaSpecific.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 2
      reverseOS.write(0x82);
      codeLength += 1;
      return codeLength;
    }

    if (domainSpecific != null) {
      codeLength += domainSpecific.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, CONSTRUCTED, 1
      reverseOS.write(0xA1);
      codeLength += 1;
      return codeLength;
    }

    if (vmdSpecific != null) {
      codeLength += vmdSpecific.encode(reverseOS, false);
      // write tag: CONTEXT_CLASS, PRIMITIVE, 0
      reverseOS.write(0x80);
      codeLength += 1;
      return codeLength;
    }

    throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
  }

  public int decode(InputStream is) throws IOException {
    return decode(is, null);
  }

  public int decode(InputStream is, BerTag berTag) throws IOException {

    int codeLength = 0;
    BerTag passedTag = berTag;

    if (berTag == null) {
      berTag = new BerTag();
      codeLength += berTag.decode(is);
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 0)) {
      vmdSpecific = new Identifier();
      codeLength += vmdSpecific.decode(is, false);
      return codeLength;
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 1)) {
      domainSpecific = new DomainSpecific();
      codeLength += domainSpecific.decode(is, false);
      return codeLength;
    }

    if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 2)) {
      aaSpecific = new Identifier();
      codeLength += aaSpecific.decode(is, false);
      return codeLength;
    }

    if (passedTag != null) {
      return 0;
    }

    throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
  }

  public void encodeAndSave(int encodingSizeGuess) throws IOException {
    ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
    encode(reverseOS);
    code = reverseOS.getArray();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder();
    appendAsString(sb, 0);
    return sb.toString();
  }

  public void appendAsString(StringBuilder sb, int indentLevel) {

    if (vmdSpecific != null) {
      sb.append("vmdSpecific: ").append(vmdSpecific);
      return;
    }

    if (domainSpecific != null) {
      sb.append("domainSpecific: ");
      domainSpecific.appendAsString(sb, indentLevel + 1);
      return;
    }

    if (aaSpecific != null) {
      sb.append("aaSpecific: ").append(aaSpecific);
      return;
    }

    sb.append("<none>");
  }

  public static class DomainSpecific implements BerType, Serializable {

    public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private Identifier domainID = null;
    private Identifier itemID = null;

    public DomainSpecific() {}

    public DomainSpecific(byte[] code) {
      this.code = code;
    }

    public Identifier getDomainID() {
      return domainID;
    }

    public void setDomainID(Identifier domainID) {
      this.domainID = domainID;
    }

    public Identifier getItemID() {
      return itemID;
    }

    public void setItemID(Identifier itemID) {
      this.itemID = itemID;
    }

    public int encode(OutputStream reverseOS) throws IOException {
      return encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

      if (code != null) {
        for (int i = code.length - 1; i >= 0; i--) {
          reverseOS.write(code[i]);
        }
        if (withTag) {
          return tag.encode(reverseOS) + code.length;
        }
        return code.length;
      }

      int codeLength = 0;
      codeLength += itemID.encode(reverseOS, true);

      codeLength += domainID.encode(reverseOS, true);

      codeLength += BerLength.encodeLength(reverseOS, codeLength);

      if (withTag) {
        codeLength += tag.encode(reverseOS);
      }

      return codeLength;
    }

    public int decode(InputStream is) throws IOException {
      return decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
      int codeLength = 0;
      int subCodeLength = 0;
      BerTag berTag = new BerTag();

      if (withTag) {
        codeLength += tag.decodeAndCheck(is);
      }

      BerLength length = new BerLength();
      codeLength += length.decode(is);

      int totalLength = length.val;
      codeLength += totalLength;

      subCodeLength += berTag.decode(is);
      if (berTag.equals(Identifier.tag)) {
        domainID = new Identifier();
        subCodeLength += domainID.decode(is, false);
        subCodeLength += berTag.decode(is);
      } else {
        throw new IOException("Tag does not match the mandatory sequence element tag.");
      }

      if (berTag.equals(Identifier.tag)) {
        itemID = new Identifier();
        subCodeLength += itemID.decode(is, false);
        if (subCodeLength == totalLength) {
          return codeLength;
        }
      }
      throw new IOException(
          "Unexpected end of sequence, length tag: "
              + totalLength
              + ", actual sequence length: "
              + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
      ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
      encode(reverseOS, false);
      code = reverseOS.getArray();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder();
      appendAsString(sb, 0);
      return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {

      sb.append("{");
      sb.append("\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      if (domainID != null) {
        sb.append("domainID: ").append(domainID);
      } else {
        sb.append("domainID: <empty-required-field>");
      }

      sb.append(",\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      if (itemID != null) {
        sb.append("itemID: ").append(itemID);
      } else {
        sb.append("itemID: <empty-required-field>");
      }

      sb.append("\n");
      for (int i = 0; i < indentLevel; i++) {
        sb.append("\t");
      }
      sb.append("}");
    }
  }
}
