/** This class file was automatically generated by jASN1 (http://www.beanit.com) */
package com.beanit.openiec61850.internal.mms.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VariableDefs implements BerType, Serializable {

  public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
  private static final long serialVersionUID = 1L;
  public byte[] code = null;
  private List<SEQUENCE> seqOf = null;

  public VariableDefs() {
    seqOf = new ArrayList<SEQUENCE>();
  }

  public VariableDefs(byte[] code) {
    this.code = code;
  }

  public List<SEQUENCE> getSEQUENCE() {
    if (seqOf == null) {
      seqOf = new ArrayList<SEQUENCE>();
    }
    return seqOf;
  }

  public int encode(OutputStream reverseOS) throws IOException {
    return encode(reverseOS, true);
  }

  public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

    if (code != null) {
      for (int i = code.length - 1; i >= 0; i--) {
        reverseOS.write(code[i]);
      }
      if (withTag) {
        return tag.encode(reverseOS) + code.length;
      }
      return code.length;
    }

    int codeLength = 0;
    for (int i = (seqOf.size() - 1); i >= 0; i--) {
      codeLength += seqOf.get(i).encode(reverseOS, true);
    }

    codeLength += BerLength.encodeLength(reverseOS, codeLength);

    if (withTag) {
      codeLength += tag.encode(reverseOS);
    }

    return codeLength;
  }

  public int decode(InputStream is) throws IOException {
    return decode(is, true);
  }

  public int decode(InputStream is, boolean withTag) throws IOException {
    int codeLength = 0;
    int subCodeLength = 0;
    if (withTag) {
      codeLength += tag.decodeAndCheck(is);
    }

    BerLength length = new BerLength();
    codeLength += length.decode(is);
    int totalLength = length.val;

    while (subCodeLength < totalLength) {
      SEQUENCE element = new SEQUENCE();
      subCodeLength += element.decode(is, true);
      seqOf.add(element);
    }
    if (subCodeLength != totalLength) {
      throw new IOException(
          "Decoded SequenceOf or SetOf has wrong length. Expected "
              + totalLength
              + " but has "
              + subCodeLength);
    }
    codeLength += subCodeLength;

    return codeLength;
  }

  public void encodeAndSave(int encodingSizeGuess) throws IOException {
    ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
    encode(reverseOS, false);
    code = reverseOS.getArray();
  }

  public String toString() {
    StringBuilder sb = new StringBuilder();
    appendAsString(sb, 0);
    return sb.toString();
  }

  public void appendAsString(StringBuilder sb, int indentLevel) {

    sb.append("{\n");
    for (int i = 0; i < indentLevel + 1; i++) {
      sb.append("\t");
    }
    if (seqOf == null) {
      sb.append("null");
    } else {
      Iterator<SEQUENCE> it = seqOf.iterator();
      if (it.hasNext()) {
        it.next().appendAsString(sb, indentLevel + 1);
        while (it.hasNext()) {
          sb.append(",\n");
          for (int i = 0; i < indentLevel + 1; i++) {
            sb.append("\t");
          }
          it.next().appendAsString(sb, indentLevel + 1);
        }
      }
    }

    sb.append("\n");
    for (int i = 0; i < indentLevel; i++) {
      sb.append("\t");
    }
    sb.append("}");
  }

  public static class SEQUENCE implements BerType, Serializable {

    public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private VariableSpecification variableSpecification = null;
    private AlternateAccess alternateAccess = null;

    public SEQUENCE() {}

    public SEQUENCE(byte[] code) {
      this.code = code;
    }

    public VariableSpecification getVariableSpecification() {
      return variableSpecification;
    }

    public void setVariableSpecification(VariableSpecification variableSpecification) {
      this.variableSpecification = variableSpecification;
    }

    public AlternateAccess getAlternateAccess() {
      return alternateAccess;
    }

    public void setAlternateAccess(AlternateAccess alternateAccess) {
      this.alternateAccess = alternateAccess;
    }

    public int encode(OutputStream reverseOS) throws IOException {
      return encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {

      if (code != null) {
        for (int i = code.length - 1; i >= 0; i--) {
          reverseOS.write(code[i]);
        }
        if (withTag) {
          return tag.encode(reverseOS) + code.length;
        }
        return code.length;
      }

      int codeLength = 0;
      if (alternateAccess != null) {
        codeLength += alternateAccess.encode(reverseOS, false);
        // write tag: CONTEXT_CLASS, CONSTRUCTED, 5
        reverseOS.write(0xA5);
        codeLength += 1;
      }

      codeLength += variableSpecification.encode(reverseOS);

      codeLength += BerLength.encodeLength(reverseOS, codeLength);

      if (withTag) {
        codeLength += tag.encode(reverseOS);
      }

      return codeLength;
    }

    public int decode(InputStream is) throws IOException {
      return decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
      int codeLength = 0;
      int subCodeLength = 0;
      BerTag berTag = new BerTag();

      if (withTag) {
        codeLength += tag.decodeAndCheck(is);
      }

      BerLength length = new BerLength();
      codeLength += length.decode(is);

      int totalLength = length.val;
      codeLength += totalLength;

      subCodeLength += berTag.decode(is);
      variableSpecification = new VariableSpecification();
      subCodeLength += variableSpecification.decode(is, berTag);
      if (subCodeLength == totalLength) {
        return codeLength;
      }
      subCodeLength += berTag.decode(is);

      if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.CONSTRUCTED, 5)) {
        alternateAccess = new AlternateAccess();
        subCodeLength += alternateAccess.decode(is, false);
        if (subCodeLength == totalLength) {
          return codeLength;
        }
      }
      throw new IOException(
          "Unexpected end of sequence, length tag: "
              + totalLength
              + ", actual sequence length: "
              + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
      ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
      encode(reverseOS, false);
      code = reverseOS.getArray();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder();
      appendAsString(sb, 0);
      return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {

      sb.append("{");
      sb.append("\n");
      for (int i = 0; i < indentLevel + 1; i++) {
        sb.append("\t");
      }
      if (variableSpecification != null) {
        sb.append("variableSpecification: ");
        variableSpecification.appendAsString(sb, indentLevel + 1);
      } else {
        sb.append("variableSpecification: <empty-required-field>");
      }

      if (alternateAccess != null) {
        sb.append(",\n");
        for (int i = 0; i < indentLevel + 1; i++) {
          sb.append("\t");
        }
        sb.append("alternateAccess: ");
        alternateAccess.appendAsString(sb, indentLevel + 1);
      }

      sb.append("\n");
      for (int i = 0; i < indentLevel; i++) {
        sb.append("\t");
      }
      sb.append("}");
    }
  }
}
