/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.integration.hibernate.base.SubselectLoaderUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.collection.SubselectOneToManyLoader;
import org.hibernate.persister.collection.QueryableCollection;

public class CustomSubselectOneToManyLoader
extends SubselectOneToManyLoader {
    private final int cteParameterCount;
    private final int selectParameterCount;

    public CustomSubselectOneToManyLoader(QueryableCollection persister, String subquery, Collection entityKeys, QueryParameters queryParameters, Map<String, int[]> namedParameterLocMap, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(persister, subquery, entityKeys, queryParameters, namedParameterLocMap, factory, loadQueryInfluencers);
        String originalSql = queryParameters.getFilteredSQL();
        if (originalSql.startsWith("with ")) {
            StringBuilder sb = new StringBuilder(this.sql.length() + originalSql.length());
            this.cteParameterCount = SubselectLoaderUtils.applyCteAndCountParameters((String)originalSql, (StringBuilder)sb);
            this.selectParameterCount = SubselectLoaderUtils.countSelectParameters((String)originalSql, (int)sb.length());
            sb.append(this.sql);
            this.sql = sb.toString();
        } else {
            this.cteParameterCount = 0;
            this.selectParameterCount = 0;
        }
    }

    protected int bindParameterValues(PreparedStatement statement, QueryParameters queryParameters, int startIndex, SharedSessionContractImplementor session) throws SQLException {
        if (this.cteParameterCount > 0) {
            statement = SubselectLoaderUtils.getPreparedStatementProxy((PreparedStatement)statement, (QueryParameters)queryParameters, (int)this.cteParameterCount, (int)this.selectParameterCount);
        }
        return super.bindParameterValues(statement, queryParameters, startIndex, session);
    }
}

