/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.integration.hibernate.PreparedStatementInvocationHandler;
import com.blazebit.persistence.integration.hibernate.base.HibernateReturningResult;
import com.blazebit.persistence.spi.DbmsDialect;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.ScrollMode;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;

public class StatementPreparerImpl
implements StatementPreparer {
    private JdbcCoordinator jdbcCoordinator;
    private SessionFactoryImplementor sessionFactoryImplementor;
    private DbmsDialect dbmsDialect;
    private String[][] columns;
    private int[] returningSqlTypes;
    private HibernateReturningResult<?> returningResult;

    public StatementPreparerImpl(JdbcCoordinator jdbcCoordinator, SessionFactoryImplementor sessionFactoryImplementor, DbmsDialect dbmsDialect, String[][] columns, int[] returningSqlTypes, HibernateReturningResult<?> returningResult) {
        this.jdbcCoordinator = jdbcCoordinator;
        this.sessionFactoryImplementor = sessionFactoryImplementor;
        this.dbmsDialect = dbmsDialect;
        this.columns = columns;
        this.returningSqlTypes = returningSqlTypes;
        this.returningResult = returningResult;
    }

    protected final SessionFactoryOptions settings() {
        return this.sessionFactoryImplementor.getSessionFactoryOptions();
    }

    protected final Connection connection() {
        return this.logicalConnection().getPhysicalConnection();
    }

    protected final LogicalConnectionImplementor logicalConnection() {
        return this.jdbcCoordinator.getLogicalConnection();
    }

    protected final SqlExceptionHelper sqlExceptionHelper() {
        return this.getJdbcService().getSqlExceptionHelper();
    }

    public Statement createStatement() {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public PreparedStatement prepareStatement(String sql) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public PreparedStatement prepareStatement(String sql, boolean isCallable) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    private void checkAutoGeneratedKeysSupportEnabled() {
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public PreparedStatement prepareQueryStatement(String sql, boolean isCallable, ScrollMode scrollMode) {
        this.checkAutoGeneratedKeysSupportEnabled();
        this.jdbcCoordinator.executeBatch();
        PreparedStatement ps = new QueryStatementPreparationTemplate(sql){

            @Override
            public PreparedStatement doPrepare() throws SQLException {
                PreparedStatement ps = StatementPreparerImpl.this.connection().prepareStatement(this.sql, StatementPreparerImpl.this.dbmsDialect.getPrepareFlags());
                return StatementPreparerImpl.this.dbmsDialect.prepare(ps, StatementPreparerImpl.this.returningSqlTypes);
            }
        }.prepareStatement();
        ps = (PreparedStatement)Proxy.newProxyInstance(ps.getClass().getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new PreparedStatementInvocationHandler(ps, this.dbmsDialect, this.columns, this.returningResult));
        this.jdbcCoordinator.registerLastQuery((Statement)ps);
        return ps;
    }

    private JdbcServices getJdbcService() {
        return (JdbcServices)this.jdbcCoordinator.getJdbcSessionOwner().getJdbcSessionContext().getServiceRegistry().getService(JdbcServices.class);
    }

    private void setStatementFetchSize(PreparedStatement statement) throws SQLException {
        if (this.settings().getJdbcFetchSize() != null) {
            statement.setFetchSize(this.settings().getJdbcFetchSize());
        }
    }

    private abstract class QueryStatementPreparationTemplate
    extends StatementPreparationTemplate {
        protected QueryStatementPreparationTemplate(String sql) {
            super(sql);
        }

        @Override
        public void postProcess(PreparedStatement preparedStatement) throws SQLException {
            super.postProcess(preparedStatement);
            StatementPreparerImpl.this.setStatementFetchSize(preparedStatement);
        }
    }

    private abstract class StatementPreparationTemplate {
        protected final String sql;

        protected StatementPreparationTemplate(String incomingSql) {
            String inspectedSql = StatementPreparerImpl.this.jdbcCoordinator.getJdbcSessionOwner().getJdbcSessionContext().getStatementInspector().inspect(incomingSql);
            this.sql = inspectedSql == null ? incomingSql : inspectedSql;
        }

        public PreparedStatement prepareStatement() {
            try {
                PreparedStatement preparedStatement;
                StatementPreparerImpl.this.getJdbcService().getSqlStatementLogger().logStatement(this.sql);
                try {
                    StatementPreparerImpl.this.jdbcCoordinator.getJdbcSessionOwner().getJdbcSessionContext().getObserver().jdbcPrepareStatementStart();
                    preparedStatement = this.doPrepare();
                    this.setStatementTimeout(preparedStatement);
                }
                finally {
                    StatementPreparerImpl.this.jdbcCoordinator.getJdbcSessionOwner().getJdbcSessionContext().getObserver().jdbcPrepareStatementEnd();
                }
                this.postProcess(preparedStatement);
                return preparedStatement;
            }
            catch (SQLException e) {
                throw StatementPreparerImpl.this.sqlExceptionHelper().convert(e, "could not prepare statement", this.sql);
            }
        }

        protected abstract PreparedStatement doPrepare() throws SQLException;

        public void postProcess(PreparedStatement preparedStatement) throws SQLException {
            StatementPreparerImpl.this.jdbcCoordinator.getResourceRegistry().register((Statement)preparedStatement, true);
        }

        private void setStatementTimeout(PreparedStatement preparedStatement) throws SQLException {
            int remainingTransactionTimeOutPeriod = StatementPreparerImpl.this.jdbcCoordinator.determineRemainingTransactionTimeOutPeriod();
            if (remainingTransactionTimeOutPeriod > 0) {
                preparedStatement.setQueryTimeout(remainingTransactionTimeOutPeriod);
            }
        }
    }
}

