/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.integration.hibernate.base.HibernateJpa21Provider;
import com.blazebit.persistence.integration.hibernate.base.function.AbstractHibernateEntityManagerFactoryIntegrator;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.spi.JpaProviderFactory;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnitUtil;
import org.hibernate.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;

public class Hibernate56EntityManagerFactoryIntegrator
extends AbstractHibernateEntityManagerFactoryIntegrator {
    public String getDbms(EntityManagerFactory entityManagerFactory) {
        if (entityManagerFactory == null) {
            return null;
        }
        return this.getDbmsName(entityManagerFactory, null, ((SessionFactoryImplementor)entityManagerFactory.unwrap(SessionFactoryImplementor.class)).getDialect());
    }

    private String getDbms(EntityManager entityManager) {
        if (entityManager == null) {
            return null;
        }
        Session s = (Session)entityManager.unwrap(Session.class);
        Dialect dialect = this.getDialect(s);
        return this.getDbmsName(entityManager.getEntityManagerFactory(), entityManager, dialect);
    }

    private Map<String, CollectionPersister> getCollectionPersisters(EntityManager em) {
        if (em == null) {
            return null;
        }
        return ((SessionImplementor)em.unwrap(SessionImplementor.class)).getFactory().getCollectionPersisters();
    }

    private Map<String, EntityPersister> getEntityPersisters(EntityManager em) {
        if (em == null) {
            return null;
        }
        return ((SessionImplementor)em.unwrap(SessionImplementor.class)).getFactory().getEntityPersisters();
    }

    public JpaProviderFactory getJpaProviderFactory(final EntityManagerFactory entityManagerFactory) {
        return new JpaProviderFactory(){

            public JpaProvider createJpaProvider(EntityManager em) {
                PersistenceUnitUtil persistenceUnitUtil;
                SessionFactoryImplementor factory = null;
                PersistenceUnitUtil persistenceUnitUtil2 = persistenceUnitUtil = entityManagerFactory == null ? null : entityManagerFactory.getPersistenceUnitUtil();
                if (persistenceUnitUtil == null && em != null) {
                    persistenceUnitUtil = em.getEntityManagerFactory().getPersistenceUnitUtil();
                }
                if (em == null) {
                    if (entityManagerFactory instanceof SessionFactoryImplementor) {
                        factory = (SessionFactoryImplementor)entityManagerFactory;
                    } else if (entityManagerFactory instanceof HibernateEntityManagerFactory) {
                        factory = ((HibernateEntityManagerFactory)entityManagerFactory).getSessionFactory();
                    }
                    if (factory == null && entityManagerFactory != null) {
                        factory = (SessionFactoryImplementor)entityManagerFactory.unwrap(SessionFactoryImplementor.class);
                    }
                    if (factory != null) {
                        return new HibernateJpa21Provider(persistenceUnitUtil, Hibernate56EntityManagerFactoryIntegrator.this.getDbmsName(entityManagerFactory, em, factory.getDialect()), factory.getEntityPersisters(), factory.getCollectionPersisters(), MAJOR, MINOR, FIX, TYPE);
                    }
                }
                return new HibernateJpa21Provider(persistenceUnitUtil, Hibernate56EntityManagerFactoryIntegrator.this.getDbms(em), Hibernate56EntityManagerFactoryIntegrator.this.getEntityPersisters(em), Hibernate56EntityManagerFactoryIntegrator.this.getCollectionPersisters(em), MAJOR, MINOR, FIX, TYPE);
            }
        };
    }
}

