/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.hibernate;

import com.blazebit.persistence.view.spi.TransactionAccess;
import com.blazebit.persistence.view.spi.TransactionSupport;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;

public class Hibernate5JtaPlatformTransactionSynchronizationStrategy
implements TransactionAccess,
TransactionSupport {
    private final JtaPlatform jtaPlatform;
    private final TransactionManager jtaTransactionManager;

    public Hibernate5JtaPlatformTransactionSynchronizationStrategy(JtaPlatform jtaPlatform) {
        this.jtaPlatform = jtaPlatform;
        this.jtaTransactionManager = jtaPlatform.retrieveTransactionManager();
    }

    public boolean isActive() {
        try {
            return this.jtaPlatform.getCurrentStatus() == 0;
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public void markRollbackOnly() {
        try {
            this.jtaTransactionManager.setRollbackOnly();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerSynchronization(Synchronization synchronization) {
        this.jtaPlatform.registerSynchronization(synchronization);
    }

    public void transactional(Runnable runnable) {
        runnable.run();
    }
}

