/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.math.ec.custom.sec;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.math.ec.ECConstants;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.math.ec.ECCurve;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.math.ec.ECFieldElement;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.math.ec.ECLookupTable;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.math.ec.ECPoint;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.math.ec.custom.sec.SecP224K1FieldElement;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.math.ec.custom.sec.SecP224K1Point;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.math.raw.Nat224;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP224K1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFE56D"));
    private static final int SECP224K1_DEFAULT_COORDS = 2;
    protected SecP224K1Point infinity = new SecP224K1Point(this, null, null);

    public SecP224K1Curve() {
        super(q);
        this.a = this.fromBigInteger(ECConstants.ZERO);
        this.b = this.fromBigInteger(BigInteger.valueOf(5L));
        this.order = new BigInteger(1, Hex.decode("010000000000000000000000000001DCE8D2EC6184CAF0A971769FB1F7"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SecP224K1Curve();
    }

    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    public int getFieldSize() {
        return q.bitLength();
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP224K1FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
        return new SecP224K1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl) {
        return new SecP224K1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final int[] nArray = new int[n2 * 7 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            Nat224.copy(((SecP224K1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat224.copy(((SecP224K1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 7);
            n3 += 7;
        }
        return new ECLookupTable(){

            public int getSize() {
                return n2;
            }

            public ECPoint lookup(int n) {
                int[] nArray3 = Nat224.create();
                int[] nArray2 = Nat224.create();
                int n22 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n3 = (i ^ n) - 1 >> 31;
                    for (int j = 0; j < 7; ++j) {
                        int n4 = j;
                        nArray3[n4] = nArray3[n4] ^ nArray[n22 + j] & n3;
                        int n5 = j;
                        nArray2[n5] = nArray2[n5] ^ nArray[n22 + 7 + j] & n3;
                    }
                    n22 += 14;
                }
                return SecP224K1Curve.this.createRawPoint(new SecP224K1FieldElement(nArray3), new SecP224K1FieldElement(nArray2), false);
            }
        };
    }
}

