/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.bmuschko.gradle.docker.shaded.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmuschko.gradle.docker.shaded.org.apache.commons.lang.builder.HashCodeBuilder;
import java.io.Serializable;

public class Link
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String alias;

    public Link(String name, String alias) {
        this.name = name;
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public static Link parse(String serialized) throws IllegalArgumentException {
        try {
            String[] parts = serialized.split(":");
            switch (parts.length) {
                case 2: {
                    String[] nameSplit = parts[0].split("/");
                    String[] aliasSplit = parts[1].split("/");
                    return new Link(nameSplit[nameSplit.length - 1], aliasSplit[aliasSplit.length - 1]);
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing Link '" + serialized + "'");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Link) {
            Link other = (Link)obj;
            return new EqualsBuilder().append(this.name, other.getName()).append(this.alias, other.getAlias()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.name).append(this.alias).toHashCode();
    }

    public String toString() {
        return this.name + ":" + this.alias;
    }
}

