/*
 * Decompiled with CFR 0.152.
 */
package com.brendangoldberg.kotlin_jwt;

import com.brendangoldberg.kotlin_jwt.Utils;
import com.brendangoldberg.kotlin_jwt.algorithms.Algorithm;
import com.brendangoldberg.kotlin_jwt.serializers.DateSerializer;
import com.brendangoldberg.kotlin_jwt.serializers.LocalDateTimeSerializer;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.BooleanCompanionObject;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/brendangoldberg/kotlin_jwt/KtJwtCreator;", "", "()V", "header", "Ljava/util/LinkedHashMap;", "", "Lkotlinx/serialization/json/JsonElement;", "Lkotlin/collections/LinkedHashMap;", "payload", "sign", "algorithm", "Lcom/brendangoldberg/kotlin_jwt/algorithms/Algorithm;", "Builder", "Companion", "lib"})
public final class KtJwtCreator {
    private final LinkedHashMap<String, JsonElement> header = new LinkedHashMap();
    private final LinkedHashMap<String, JsonElement> payload = new LinkedHashMap();
    private static final KSerializer<String> S_STRING;
    private static final KSerializer<List<String>> S_STRING_LIST;
    private static final KSerializer<Double> S_DOUBLE;
    private static final KSerializer<Long> S_LONG;
    private static final KSerializer<Integer> S_INT;
    private static final KSerializer<Boolean> S_BOOLEAN;
    private static final Base64.Encoder encoder;
    private static final Json json;
    @NotNull
    public static final Companion Companion;

    private final String sign(Algorithm algorithm) {
        this.header.putIfAbsent("alg", KtJwtCreator.Companion.toJson(algorithm.getId()));
        String headerJson = new JsonObject((Map)this.header).toString();
        String payloadJson = new JsonObject((Map)this.payload).toString();
        String string = headerJson;
        Object object = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes((Charset)object);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] headerBytes = byArray;
        object = payloadJson;
        Charset charset = Charsets.UTF_8;
        boolean bl2 = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray2 = ((String)object2).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] payloadBytes = byArray2;
        String tHeader = encoder.encodeToString(headerBytes);
        String tPayload = encoder.encodeToString(payloadBytes);
        String signature = algorithm.sign(headerJson, payloadJson);
        return tHeader + '.' + tPayload + '.' + signature;
    }

    private KtJwtCreator() {
    }

    static {
        Companion = new Companion(null);
        S_STRING = BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE);
        S_STRING_LIST = BuiltinSerializersKt.ListSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE));
        S_DOUBLE = BuiltinSerializersKt.serializer((DoubleCompanionObject)DoubleCompanionObject.INSTANCE);
        S_LONG = BuiltinSerializersKt.serializer((LongCompanionObject)LongCompanionObject.INSTANCE);
        S_INT = BuiltinSerializersKt.serializer((IntCompanionObject)IntCompanionObject.INSTANCE);
        S_BOOLEAN = BuiltinSerializersKt.serializer((BooleanCompanionObject)BooleanCompanionObject.INSTANCE);
        encoder = Utils.INSTANCE.getENCODER();
        json = Utils.INSTANCE.getJSON();
    }

    public /* synthetic */ KtJwtCreator(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0005\u001a\u00020\u0000\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u0002H\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\rJ\u0016\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eJ\u0016\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000fJ\u0016\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010J\u0016\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bJ\u001f\u0010\u0012\u001a\u00020\u00002\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0014\"\u00020\b\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0018J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0010J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0018J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0019J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/brendangoldberg/kotlin_jwt/KtJwtCreator$Builder;", "", "()V", "jwt", "Lcom/brendangoldberg/kotlin_jwt/KtJwtCreator;", "addClaim", "T", "key", "", "value", "serializer", "Lkotlinx/serialization/KSerializer;", "(Ljava/lang/String;Ljava/lang/Object;Lkotlinx/serialization/KSerializer;)Lcom/brendangoldberg/kotlin_jwt/KtJwtCreator$Builder;", "", "", "", "", "setAlgorithm", "setAudience", "values", "", "([Ljava/lang/String;)Lcom/brendangoldberg/kotlin_jwt/KtJwtCreator$Builder;", "setContentType", "setExpiresAt", "Ljava/time/LocalDateTime;", "Ljava/util/Date;", "setIssuedAt", "epochSecond", "setIssuer", "setJwtId", "setNotBefore", "setSubject", "setType", "sign", "algorithm", "Lcom/brendangoldberg/kotlin_jwt/algorithms/Algorithm;", "lib"})
    public static final class Builder {
        private final KtJwtCreator jwt = new KtJwtCreator(null);

        @NotNull
        public final Builder addClaim(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            ((Map)$this$apply.jwt.payload).put(key, Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final Builder addClaim(@NotNull String key, boolean value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            ((Map)$this$apply.jwt.payload).put(key, Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final Builder addClaim(@NotNull String key, int value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            ((Map)$this$apply.jwt.payload).put(key, Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final Builder addClaim(@NotNull String key, long value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            ((Map)$this$apply.jwt.payload).put(key, Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final Builder addClaim(@NotNull String key, double value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            ((Map)$this$apply.jwt.payload).put(key, Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final <T> Builder addClaim(@NotNull String key, T value, @NotNull KSerializer<T> serializer) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            ((Map)$this$apply.jwt.payload).put(key, json.encodeToJsonElement((SerializationStrategy)serializer, value));
            return builder;
        }

        @NotNull
        public final Builder setIssuer(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.jwt.payload.putIfAbsent("iss", Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final Builder setSubject(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.jwt.payload.putIfAbsent("sub", Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final Builder setAudience(String ... values) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.jwt.payload.putIfAbsent("aud", Companion.toJson(ArraysKt.toList((Object[])values)));
            return builder;
        }

        @NotNull
        public final Builder setExpiresAt(@NotNull Date value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.jwt.payload.putIfAbsent("exp", Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final Builder setExpiresAt(@NotNull LocalDateTime value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.jwt.payload.putIfAbsent("exp", Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final Builder setNotBefore(@NotNull Date value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.jwt.payload.putIfAbsent("nbf", Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final Builder setNotBefore(@NotNull LocalDateTime value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.jwt.payload.putIfAbsent("nbf", Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final Builder setIssuedAt(@NotNull Date value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.jwt.payload.putIfAbsent("iat", Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final Builder setIssuedAt(long epochSecond) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.jwt.payload.putIfAbsent("iat", Companion.toJson(epochSecond));
            return builder;
        }

        @NotNull
        public final Builder setIssuedAt(@NotNull LocalDateTime value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.jwt.payload.putIfAbsent("iat", Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final Builder setJwtId(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.jwt.payload.putIfAbsent("jti", Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final Builder setAlgorithm(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.jwt.header.putIfAbsent("alg", Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final Builder setType(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.jwt.header.putIfAbsent("typ", Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final Builder setContentType(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.jwt.header.putIfAbsent("cty", Companion.toJson(value));
            return builder;
        }

        @NotNull
        public final String sign(@NotNull Algorithm algorithm) {
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            return this.jwt.sign(algorithm);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0019H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0005H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0007H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\tH\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u000bH\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\rH\u0002J\u0012\u0010\u0016\u001a\u00020\u0017*\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/brendangoldberg/kotlin_jwt/KtJwtCreator$Companion;", "", "()V", "S_BOOLEAN", "Lkotlinx/serialization/KSerializer;", "", "S_DOUBLE", "", "S_INT", "", "S_LONG", "", "S_STRING", "", "S_STRING_LIST", "", "encoder", "Ljava/util/Base64$Encoder;", "json", "Lkotlinx/serialization/json/Json;", "init", "Lcom/brendangoldberg/kotlin_jwt/KtJwtCreator$Builder;", "toJson", "Lkotlinx/serialization/json/JsonElement;", "Ljava/time/LocalDateTime;", "Ljava/util/Date;", "lib"})
    public static final class Companion {
        @NotNull
        public final Builder init() {
            return new Builder();
        }

        private final JsonElement toJson(String $this$toJson) {
            return json.encodeToJsonElement((SerializationStrategy)S_STRING, (Object)$this$toJson);
        }

        private final JsonElement toJson(double $this$toJson) {
            return json.encodeToJsonElement((SerializationStrategy)S_DOUBLE, (Object)$this$toJson);
        }

        private final JsonElement toJson(long $this$toJson) {
            return json.encodeToJsonElement((SerializationStrategy)S_LONG, (Object)$this$toJson);
        }

        private final JsonElement toJson(int $this$toJson) {
            return json.encodeToJsonElement((SerializationStrategy)S_INT, (Object)$this$toJson);
        }

        private final JsonElement toJson(boolean $this$toJson) {
            return json.encodeToJsonElement((SerializationStrategy)S_BOOLEAN, (Object)$this$toJson);
        }

        private final JsonElement toJson(Date $this$toJson) {
            return json.encodeToJsonElement((SerializationStrategy)DateSerializer.INSTANCE, (Object)$this$toJson);
        }

        private final JsonElement toJson(LocalDateTime $this$toJson) {
            return json.encodeToJsonElement((SerializationStrategy)LocalDateTimeSerializer.INSTANCE, (Object)$this$toJson);
        }

        private final JsonElement toJson(List<String> $this$toJson) {
            return json.encodeToJsonElement((SerializationStrategy)S_STRING_LIST, $this$toJson);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

