/*
 * Decompiled with CFR 0.152.
 */
package com.brendangoldberg.kotlin_jwt;

import com.brendangoldberg.kotlin_jwt.Utils;
import java.nio.charset.Charset;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/brendangoldberg/kotlin_jwt/Utils;", "", "()V", "DECODER", "Ljava/util/Base64$Decoder;", "getDECODER", "()Ljava/util/Base64$Decoder;", "ENCODER", "Ljava/util/Base64$Encoder;", "getENCODER", "()Ljava/util/Base64$Encoder;", "JSON", "Lkotlinx/serialization/json/Json;", "getJSON", "()Lkotlinx/serialization/json/Json;", "sign", "", "algorithm", "secret", "", "header", "payload", "verify", "", "signature", "lib"})
public final class Utils {
    @NotNull
    private static final Json JSON;
    @NotNull
    private static final Base64.Decoder DECODER;
    @NotNull
    private static final Base64.Encoder ENCODER;
    @NotNull
    public static final Utils INSTANCE;

    @NotNull
    public final Json getJSON() {
        return JSON;
    }

    @NotNull
    public final Base64.Decoder getDECODER() {
        return DECODER;
    }

    @NotNull
    public final Base64.Encoder getENCODER() {
        return ENCODER;
    }

    @NotNull
    public final String sign(@NotNull String algorithm, @NotNull byte[] secret, @NotNull String header, @NotNull String payload) {
        String data;
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(secret, algorithm));
        StringBuilder stringBuilder = new StringBuilder();
        String string = header;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        StringBuilder stringBuilder2 = stringBuilder.append(ENCODER.encodeToString(byArray)).append(".");
        string = payload;
        charset = Charsets.UTF_8;
        bl = false;
        byte[] byArray2 = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        string = data = stringBuilder2.append(ENCODER.encodeToString(byArray2)).toString();
        charset = Charsets.UTF_8;
        bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray3 = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        String string3 = ENCODER.encodeToString(mac.doFinal(byArray3));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ENCODER.encodeToString(m\u2026inal(data.toByteArray()))");
        return StringsKt.trimEnd((String)string3, (char[])new char[]{'='});
    }

    public final boolean verify(@NotNull String algorithm, @NotNull byte[] secret, @NotNull String header, @NotNull String payload, @NotNull String signature) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        String other = this.sign(algorithm, secret, header, payload);
        return Intrinsics.areEqual((Object)signature, (Object)other);
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
        JSON = JsonKt.Json$default(null, (Function1)JSON.1.INSTANCE, (int)1, null);
        Base64.Decoder decoder = Base64.getUrlDecoder();
        Intrinsics.checkNotNullExpressionValue((Object)decoder, (String)"Base64.getUrlDecoder()");
        DECODER = decoder;
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        Intrinsics.checkNotNullExpressionValue((Object)encoder, (String)"Base64.getUrlEncoder().withoutPadding()");
        ENCODER = encoder;
    }
}

