/*
 * Decompiled with CFR 0.152.
 */
package com.brendangoldberg.kotlin_jwt.algorithms;

import com.brendangoldberg.kotlin_jwt.Utils;
import com.brendangoldberg.kotlin_jwt.algorithms.Algorithm;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB#\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/brendangoldberg/kotlin_jwt/algorithms/HSAlgorithm;", "Lcom/brendangoldberg/kotlin_jwt/algorithms/Algorithm;", "id", "", "algorithm", "secret", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "sign", "header", "payload", "verify", "", "signature", "Companion", "lib"})
public final class HSAlgorithm
implements Algorithm {
    @NotNull
    private final String id;
    private final String algorithm;
    private final String secret;
    private static final Pair<String, String> HS256;
    private static final Pair<String, String> HS384;
    private static final Pair<String, String> HS512;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public String sign(@NotNull String header, @NotNull String payload) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        String string = this.secret;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return Utils.INSTANCE.sign(this.algorithm, byArray, header, payload);
    }

    @Override
    public boolean verify(@NotNull String header, @NotNull String payload, @NotNull String signature) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        String string = this.secret;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return Utils.INSTANCE.verify(this.algorithm, byArray, header, payload, signature);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    private HSAlgorithm(String id, String algorithm, String secret) {
        this.id = id;
        this.algorithm = algorithm;
        this.secret = secret;
    }

    /* synthetic */ HSAlgorithm(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = (String)HS256.getFirst();
        }
        if ((n & 2) != 0) {
            string2 = (String)HS256.getSecond();
        }
        this(string, string2, string3);
    }

    static {
        Companion = new Companion(null);
        HS256 = TuplesKt.to((Object)"HS256", (Object)"HmacSHA256");
        HS384 = TuplesKt.to((Object)"HS384", (Object)"HmacSHA384");
        HS512 = TuplesKt.to((Object)"HS512", (Object)"HmacSHA512");
    }

    public /* synthetic */ HSAlgorithm(String id, String algorithm, String secret, DefaultConstructorMarker $constructor_marker) {
        this(id, algorithm, secret);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/brendangoldberg/kotlin_jwt/algorithms/HSAlgorithm$Companion;", "", "()V", "HS256", "Lkotlin/Pair;", "", "HS384", "HS512", "Lcom/brendangoldberg/kotlin_jwt/algorithms/HSAlgorithm;", "secret", "lib"})
    public static final class Companion {
        @NotNull
        public final HSAlgorithm HS256(@NotNull String secret) {
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            return new HSAlgorithm((String)HS256.getFirst(), (String)HS256.getSecond(), secret, null);
        }

        @NotNull
        public final HSAlgorithm HS384(@NotNull String secret) {
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            return new HSAlgorithm((String)HS384.getFirst(), (String)HS384.getSecond(), secret, null);
        }

        @NotNull
        public final HSAlgorithm HS512(@NotNull String secret) {
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            return new HSAlgorithm((String)HS512.getFirst(), (String)HS512.getSecond(), secret, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

