/*
 * Modifications Copyright (c) 2019 BrowserUp, Inc.
 */

package com.browserup.bup.mitm;

import java.security.cert.X509Certificate;
import java.util.List;

/**
 * A functional interface to allow customization of the certificates generated by the
 * {@link com.browserup.bup.mitm.manager.ImpersonatingMitmManager}.
 */
public interface CertificateInfoGenerator {
    /**
     * Generate a certificate for the specified hostnames, optionally using parameters from the originalCertificate.
     *
     * @param hostnames the hostnames to generate the certificate for, which may include wildcards
     * @param originalCertificate original X.509 certificate sent by the upstream server, which may be null
     * @return CertificateInfo to be used to create an X509Certificate for the specified hostnames
     */
    CertificateInfo generate(List<String> hostnames, X509Certificate originalCertificate);
}
