/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule;

import com.bstek.urule.Utils;
import com.bstek.urule.model.Label;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.library.variable.Act;
import com.bstek.urule.model.library.variable.Variable;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class ClassUtils {
    private static ConcurrentHashMap<String, Class<?>> a = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> b = new ConcurrentHashMap();

    public static void classToXml(Class<?> clazz, File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        FileOutputStream fileOutputStream = null;
        try {
            Variable variable2;
            fileOutputStream = new FileOutputStream(file);
            List<Variable> list = ClassUtils.classToVariables(clazz);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<variables clazz=\"" + clazz.getName() + "\">");
            for (Variable variable2 : list) {
                stringBuffer.append("<variable ");
                stringBuffer.append("name=\"" + variable2.getName() + "\" ");
                if (variable2.getLabel() != null) {
                    stringBuffer.append("label=\"" + variable2.getLabel() + "\" ");
                }
                if (variable2.getDefaultValue() != null) {
                    stringBuffer.append("defaultValue=\"" + variable2.getDefaultValue() + "\" ");
                }
                if (variable2.getType() != null) {
                    stringBuffer.append("type=\"" + (Object)((Object)variable2.getType()) + "\" ");
                }
                if (variable2.getAct() != null) {
                    stringBuffer.append("act=\"" + (Object)((Object)variable2.getAct()) + "\" ");
                }
                stringBuffer.append(">");
                stringBuffer.append("</variable>");
            }
            stringBuffer.append("</variables>");
            Document document = DocumentHelper.parseText((String)stringBuffer.toString());
            variable2 = OutputFormat.createPrettyPrint();
            variable2.setEncoding("utf-8");
            XMLWriter xMLWriter = new XMLWriter((OutputStream)fileOutputStream, (OutputFormat)variable2);
            xMLWriter.write(document);
            xMLWriter.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            try {
                throw new RuntimeException(exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    public static List<Variable> classToVariables(Class<?> clazz) {
        try {
            List<Variable> list = ClassUtils.a("", clazz, new ArrayList());
            return list;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Class<?> doGetTargetClass(String string, boolean bl) throws ClassNotFoundException {
        if (a.containsKey(string)) {
            return a.get(string);
        }
        Class<?> clazz = null;
        if (b.contains(string)) {
            if (bl) {
                throw new ClassNotFoundException(string);
            }
            return null;
        }
        if (a.contains(string)) {
            return a.get(string);
        }
        try {
            clazz = Class.forName(string);
            a.put(string, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)Utils.getApplicationContext().getAutowireCapableBeanFactory();
                clazz = defaultListableBeanFactory.getBeanClassLoader().loadClass(string);
                a.put(string, clazz);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                b.put(string, string);
                if (bl) {
                    throw classNotFoundException2;
                }
                return null;
            }
        }
        a.put(string, clazz);
        return clazz;
    }

    public static Class<?> getTargetClass(String string) throws ClassNotFoundException {
        return ClassUtils.doGetTargetClass(string, true);
    }

    public static Class<?> getTargetClassDefaultNull(String string) throws ClassNotFoundException {
        return ClassUtils.doGetTargetClass(string, false);
    }

    private static List<Variable> a(String string, Class<?> clazz, Collection<Class<?>> collection) throws Exception {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Object.class);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        if (propertyDescriptorArray != null && !collection.contains(clazz)) {
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                Variable variable = new Variable();
                Class<?> clazz2 = propertyDescriptor.getPropertyType();
                Datatype datatype = ClassUtils.a(clazz2);
                String string2 = propertyDescriptor.getName();
                String string3 = ClassUtils.a(clazz, string2);
                String string4 = string + propertyDescriptor.getName();
                variable.setName(string4);
                variable.setUuid(UUID.randomUUID().toString());
                variable.setLabel(string3 == null ? string4 : string3);
                variable.setType(datatype);
                variable.setAct(Act.InOut);
                if (Datatype.Object.equals((Object)datatype) && !clazz2.equals(Object.class)) {
                    if (collection.contains(clazz) || collection.contains(clazz2)) continue;
                    collection.add(clazz);
                    arrayList.add(variable);
                    arrayList.addAll(ClassUtils.a(string + propertyDescriptor.getName() + ".", clazz2, collection));
                    collection.remove(clazz);
                    continue;
                }
                arrayList.add(variable);
            }
        }
        return arrayList;
    }

    private static String a(Class<?> clazz, String string) throws Exception {
        Field field = null;
        while (field == null) {
            try {
                field = clazz.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (clazz == Object.class) {
                    throw noSuchFieldException;
                }
                clazz = clazz.getSuperclass();
            }
        }
        Label label = field.getAnnotation(Label.class);
        if (label != null) {
            return label.value();
        }
        return null;
    }

    private static Datatype a(Class<?> clazz) {
        if (String.class.isAssignableFrom(clazz)) {
            return Datatype.String;
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return Datatype.Boolean;
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return Datatype.Integer;
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return Datatype.Float;
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return Datatype.Long;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return Datatype.BigDecimal;
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return Datatype.Double;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return Datatype.Date;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return Datatype.Date;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return Datatype.List;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return Datatype.Map;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return Datatype.Set;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return Datatype.Enum;
        }
        if (Character.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz)) {
            return Datatype.Char;
        }
        return Datatype.Object;
    }

    public static void cleanClassesCache() {
        a.clear();
        b.clear();
    }
}

