/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.builder;

import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.decisiontree.ActionTreeNode;
import com.bstek.urule.model.decisiontree.ConditionTreeNode;
import com.bstek.urule.model.decisiontree.DecisionTree;
import com.bstek.urule.model.decisiontree.TreeNode;
import com.bstek.urule.model.decisiontree.VariableTreeNode;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.Rhs;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.RuleSet;
import com.bstek.urule.model.rule.lhs.And;
import com.bstek.urule.model.rule.lhs.Criteria;
import com.bstek.urule.model.rule.lhs.Lhs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DecisionTreeRulesBuilder {
    public RuleSet buildRules(DecisionTree decisionTree, String string) throws IOException {
        RuleSet ruleSet = new RuleSet();
        List<Library> list = decisionTree.getLibraries();
        if (list != null) {
            for (Library object2 : list) {
                ruleSet.addLibrary(object2);
            }
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(decisionTree.getVariableTreeNode());
        ArrayList<ActionTreeNode> arrayList2 = new ArrayList<ActionTreeNode>();
        this.fetchActionTreeNodes(arrayList, arrayList2);
        ArrayList<Rule> arrayList3 = new ArrayList<Rule>();
        for (ActionTreeNode actionTreeNode : arrayList2) {
            Rule rule = new Rule();
            rule.setFile(string);
            rule.setDebug(decisionTree.getDebug());
            rule.setEnabled(decisionTree.getEnabled());
            rule.setEffectiveDate(decisionTree.getEffectiveDate());
            rule.setExpiresDate(decisionTree.getExpiresDate());
            rule.setSalience(decisionTree.getSalience());
            arrayList3.add(rule);
            rule.setName("tree-rule");
            Rhs rhs = new Rhs();
            rhs.setActions(actionTreeNode.getActions());
            rule.setRhs(rhs);
            Lhs lhs = new Lhs();
            rule.setLhs(lhs);
            And and = new And();
            lhs.setCriterion(and);
            ConditionTreeNode conditionTreeNode = (ConditionTreeNode)actionTreeNode.getParentNode();
            this.a(and, conditionTreeNode);
        }
        ruleSet.setRules(arrayList3);
        return ruleSet;
    }

    private void a(And and, ConditionTreeNode conditionTreeNode) {
        if (conditionTreeNode == null) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(conditionTreeNode);
        VariableTreeNode variableTreeNode = null;
        TreeNode treeNode = conditionTreeNode.getParentNode();
        while (treeNode != null) {
            if (treeNode instanceof VariableTreeNode) {
                variableTreeNode = (VariableTreeNode)treeNode;
                this.a(and, (ConditionTreeNode)treeNode.getParentNode());
                break;
            }
            if (!(treeNode instanceof ConditionTreeNode)) continue;
            ConditionTreeNode conditionTreeNode2 = (ConditionTreeNode)treeNode;
            arrayList.add(conditionTreeNode2);
            treeNode = conditionTreeNode2.getParentNode();
        }
        if (variableTreeNode == null) {
            throw new RuleException("Decision tree is invalid.");
        }
        for (ConditionTreeNode conditionTreeNode3 : arrayList) {
            and.addCriterion(this.a(conditionTreeNode3, variableTreeNode));
        }
    }

    private Criteria a(ConditionTreeNode conditionTreeNode, VariableTreeNode variableTreeNode) {
        Criteria criteria = new Criteria();
        criteria.setLeft(variableTreeNode.getLeft());
        criteria.setOp(conditionTreeNode.getOp());
        criteria.setValue(conditionTreeNode.getValue());
        return criteria;
    }

    public void fetchActionTreeNodes(List<? extends TreeNode> list, List<ActionTreeNode> list2) {
        for (TreeNode treeNode : list) {
            List<VariableTreeNode> list3;
            List<ConditionTreeNode> list4;
            List<TreeNode> list5;
            TreeNode treeNode2;
            if (treeNode instanceof ActionTreeNode) {
                list2.add((ActionTreeNode)treeNode);
                continue;
            }
            if (treeNode instanceof VariableTreeNode) {
                treeNode2 = (VariableTreeNode)treeNode;
                list5 = ((VariableTreeNode)treeNode2).getConditionTreeNodes();
                if (list5 == null) continue;
                this.fetchActionTreeNodes(list5, list2);
                continue;
            }
            if (!(treeNode instanceof ConditionTreeNode)) continue;
            treeNode2 = (ConditionTreeNode)treeNode;
            list5 = ((ConditionTreeNode)treeNode2).getActionTreeNodes();
            if (list5 != null) {
                this.fetchActionTreeNodes(list5, list2);
            }
            if ((list4 = ((ConditionTreeNode)treeNode2).getConditionTreeNodes()) != null) {
                this.fetchActionTreeNodes(list4, list2);
            }
            if ((list3 = ((ConditionTreeNode)treeNode2).getVariableTreeNodes()) == null) continue;
            this.fetchActionTreeNodes(list3, list2);
        }
    }
}

