/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.builder.rete;

import com.bstek.urule.Utils;
import com.bstek.urule.builder.resource.ResourceType;
import com.bstek.urule.builder.rete.BuildContext;
import com.bstek.urule.builder.rete.BuildContextImpl;
import com.bstek.urule.builder.rete.CriterionBuilder;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.Node;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.rete.BaseReteNode;
import com.bstek.urule.model.rete.CriteriaNode;
import com.bstek.urule.model.rete.JunctionNode;
import com.bstek.urule.model.rete.Line;
import com.bstek.urule.model.rete.MutexReteUnit;
import com.bstek.urule.model.rete.ObjectTypeNode;
import com.bstek.urule.model.rete.Rete;
import com.bstek.urule.model.rete.ReteUnit;
import com.bstek.urule.model.rete.RuleData;
import com.bstek.urule.model.rete.TerminalNode;
import com.bstek.urule.model.rule.Other;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.lhs.BaseCriterion;
import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.lhs.Lhs;
import com.bstek.urule.model.rule.loop.LoopRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ReteBuilder
implements ApplicationContextAware {
    public static final String BEAN_ID = "urule.reteBuilder";
    private static Collection<CriterionBuilder> a;

    public Rete buildRete(List<Rule> list, ResourceLibrary resourceLibrary) {
        return this.a(list, resourceLibrary);
    }

    public Rete buildRete(Rule rule, ResourceLibrary resourceLibrary) {
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        arrayList.add(rule);
        return this.a(arrayList, resourceLibrary);
    }

    private Rete a(List<Rule> list, ResourceLibrary resourceLibrary) {
        ArrayList<ObjectTypeNode> arrayList = new ArrayList<ObjectTypeNode>();
        Rete rete = new Rete(arrayList, resourceLibrary);
        BuildContextImpl buildContextImpl = new BuildContextImpl(resourceLibrary, arrayList);
        HashMap<String, List<Rule>> hashMap = new HashMap<String, List<Rule>>();
        HashMap<String, List<Rule>> hashMap2 = new HashMap<String, List<Rule>>();
        ArrayList<RuleData> arrayList2 = new ArrayList<RuleData>();
        rete.setAllRuleData(arrayList2);
        for (Rule rule : list) {
            List<Object> list2;
            if (this.a(rule)) continue;
            if (StringUtils.isNotBlank((String)rule.getPendedGroup())) {
                list2 = (ArrayList<Rule>)hashMap2.get(rule.getPendedGroup());
                if (list2 == null) {
                    list2 = new ArrayList<Rule>();
                    hashMap2.put(rule.getPendedGroup(), list2);
                }
                list2.add(rule);
                continue;
            }
            if (StringUtils.isNotBlank((String)rule.getMutexGroup())) {
                list2 = (List)hashMap.get(rule.getMutexGroup());
                if (list2 == null) {
                    list2 = new ArrayList();
                    hashMap.put(rule.getMutexGroup(), list2);
                }
                list2.add(rule);
                continue;
            }
            if (!rule.isTargetResource(ResourceType.Flow)) {
                arrayList2.add(new RuleData(rule));
            }
            list2 = new TerminalNode(rule, buildContextImpl.nextId());
            this.a(rule, (BuildContext)buildContextImpl, (TerminalNode)((Object)list2));
            rule.setLhs(null);
        }
        rete.setPendedGroupRetesMap(this.a(hashMap2, (BuildContext)buildContextImpl, true));
        rete.setMutexGroupRetesMap(this.a(hashMap, (BuildContext)buildContextImpl, false));
        return rete;
    }

    private boolean a(Rule rule) {
        Date date;
        if (rule.getEnabled() != null && !rule.getEnabled().booleanValue()) {
            return true;
        }
        Date date2 = rule.getExpiresDate();
        return date2 != null && date2.compareTo(date = new Date()) < 0;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, List<ReteUnit>> a(Map<String, List<Rule>> map, BuildContext buildContext, boolean bl) {
        if (map.size() == 0) {
            return null;
        }
        ResourceLibrary resourceLibrary = buildContext.getResourceLibrary();
        HashMap<String, List<ReteUnit>> hashMap = new HashMap<String, List<ReteUnit>>();
        for (String string : map.keySet()) {
            List<ObjectTypeNode> list;
            List<Rule> list3 = map.get(string);
            this.a(list3);
            HashMap<String, List<Rule>> hashMap2 = new HashMap<String, List<Rule>>();
            for (Rule rule : list3) {
                ArrayList<Rule> arrayList;
                String string2 = rule.getMutexGroup();
                if (bl && StringUtils.isNotBlank((String)string2)) {
                    arrayList = (List)hashMap2.get(string2);
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                        hashMap2.put(string2, (List<Rule>)arrayList);
                    }
                    arrayList.add(rule);
                    continue;
                }
                arrayList = (ArrayList<Rule>)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<Rule>();
                    hashMap.put(string, arrayList);
                }
                list = new ArrayList<ObjectTypeNode>();
                Rete rete = new Rete(list, resourceLibrary);
                BuildContextImpl buildContextImpl = new BuildContextImpl(list, buildContext);
                TerminalNode terminalNode = new TerminalNode(rule, buildContextImpl.nextId());
                this.a(rule, (BuildContext)buildContextImpl, terminalNode);
                ReteUnit reteUnit = new ReteUnit(rete, rule.getName());
                reteUnit.setEffectiveDate(rule.getEffectiveDate());
                reteUnit.setExpiresDate(rule.getExpiresDate());
                arrayList.add((Rule)((Object)reteUnit));
                rule.setLhs(null);
                buildContext = buildContextImpl;
            }
            Map<String, List<ReteUnit>> map2 = this.a(buildContext, resourceLibrary, hashMap2);
            List list2 = (List)hashMap.get(string);
            if (list2 == null) {
                ArrayList arrayList = new ArrayList();
                hashMap.put(string, arrayList);
            }
            for (ArrayList<Rule> arrayList : map2.keySet()) {
                void list22;
                list = (List)map2.get(arrayList);
                list22.add(new MutexReteUnit((String)((Object)arrayList), list));
            }
        }
        return hashMap;
    }

    private Map<String, List<ReteUnit>> a(BuildContext buildContext, ResourceLibrary resourceLibrary, Map<String, List<Rule>> map) {
        HashMap<String, List<ReteUnit>> hashMap = new HashMap<String, List<ReteUnit>>();
        for (String string : map.keySet()) {
            ArrayList<ReteUnit> arrayList = (ArrayList<ReteUnit>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<ReteUnit>();
                hashMap.put(string, arrayList);
            }
            List<Rule> list = map.get(string);
            for (Rule rule : list) {
                ArrayList<ObjectTypeNode> arrayList2 = new ArrayList<ObjectTypeNode>();
                Rete rete = new Rete(arrayList2, resourceLibrary);
                BuildContextImpl buildContextImpl = new BuildContextImpl(arrayList2, buildContext);
                TerminalNode terminalNode = new TerminalNode(rule, buildContextImpl.nextId());
                this.a(rule, (BuildContext)buildContextImpl, terminalNode);
                ReteUnit reteUnit = new ReteUnit(rete, rule.getName());
                arrayList.add(reteUnit);
                rule.setLhs(null);
                buildContext = buildContextImpl;
            }
        }
        return hashMap;
    }

    private void a(List<Rule> list) {
        Collections.sort(list, new Comparator<Rule>(){

            @Override
            public int compare(Rule rule, Rule rule2) {
                Integer n = rule.getSalience();
                Integer n2 = rule2.getSalience();
                if (n != null && n2 != null) {
                    return n2 - n;
                }
                if (n2 != null) {
                    return -1;
                }
                if (n != null) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private void a(Rule rule, BuildContext buildContext, TerminalNode terminalNode) {
        buildContext.setCurrentRule(rule);
        Lhs lhs = rule.getLhs();
        if (rule instanceof LoopRule || lhs == null || lhs.getCriterion() == null) {
            ObjectTypeNode objectTypeNode = buildContext.buildObjectTypeNode("__*__");
            objectTypeNode.addLine(terminalNode);
        } else {
            Criterion criterion = lhs.getCriterion();
            List<BaseReteNode> list = ReteBuilder.buildCriterion(buildContext, criterion);
            for (BaseReteNode baseReteNode : list) {
                Line line;
                Node node;
                JunctionNode junctionNode;
                List<Line> list2;
                if (baseReteNode instanceof JunctionNode && (list2 = (junctionNode = (JunctionNode)baseReteNode).getToConnections()).size() == 1 && (node = (line = list2.get(0)).getFrom()) instanceof CriteriaNode) {
                    CriteriaNode criteriaNode = (CriteriaNode)node;
                    criteriaNode.getLines().remove(line);
                    baseReteNode = criteriaNode;
                }
                baseReteNode.addLine(terminalNode);
            }
            Other other = rule.getOther();
            if (other != null && other.getActions() != null && other.getActions().size() > 0) {
                BaseReteNode baseReteNode;
                rule.setWithElse(true);
                Utils.buildElseRule(rule);
                baseReteNode = buildContext.buildObjectTypeNode("__*__");
                baseReteNode.addLine(terminalNode);
            }
        }
    }

    public static List<BaseReteNode> buildCriterion(BuildContext buildContext, Criterion criterion) {
        for (CriterionBuilder criterionBuilder : a) {
            if (!criterionBuilder.support(criterion)) continue;
            return criterionBuilder.buildCriterion((BaseCriterion)criterion, buildContext);
        }
        throw new RuleException("Unknow criterion : " + criterion);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        a = applicationContext.getBeansOfType(CriterionBuilder.class).values();
    }
}

