/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.builder.table;

import com.bstek.urule.action.AbstractAction;
import com.bstek.urule.action.Action;
import com.bstek.urule.action.ConsolePrintAction;
import com.bstek.urule.action.VariableAssignAction;
import com.bstek.urule.builder.table.CellContentBuilder;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.rule.Rhs;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.lhs.And;
import com.bstek.urule.model.rule.lhs.Criterion;
import com.bstek.urule.model.rule.lhs.Lhs;
import com.bstek.urule.model.table.Cell;
import com.bstek.urule.model.table.Column;
import com.bstek.urule.model.table.ColumnType;
import com.bstek.urule.model.table.DecisionTable;
import com.bstek.urule.model.table.Row;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DecisionTableRulesBuilder {
    private CellContentBuilder a;

    public List<Rule> buildRules(DecisionTable decisionTable, String string) {
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        List<Row> list = decisionTable.getRows();
        List<Column> list2 = decisionTable.getColumns();
        for (Row row : list) {
            Rule rule = new Rule();
            rule.setFile(string);
            rule.setDebug(decisionTable.getDebug());
            rule.setSalience(decisionTable.getSalience());
            rule.setExpiresDate(decisionTable.getExpiresDate());
            rule.setEffectiveDate(decisionTable.getEffectiveDate());
            rule.setEnabled(decisionTable.getEnabled());
            rule.setName("r" + row.getNum());
            Lhs lhs = new Lhs();
            And and = new And();
            rule.setLhs(lhs);
            Rhs rhs = new Rhs();
            rule.setRhs(rhs);
            arrayList.add(rule);
            Value value = null;
            for (Column column : list2) {
                Cell cell = this.a(decisionTable, row.getNum(), column.getNum());
                ColumnType columnType = column.getType();
                switch (columnType) {
                    case Criteria: {
                        Criterion criterion = this.a.buildCriterion(cell, column);
                        if (criterion == null) break;
                        and.addCriterion(criterion);
                        break;
                    }
                    case ConsolePrint: {
                        value = cell.getValue();
                        if (value == null) break;
                        Action action = new ConsolePrintAction();
                        ((AbstractAction)action).setPriority(1000 - column.getNum());
                        ((ConsolePrintAction)action).setValue(value);
                        rhs.addAction(action);
                        break;
                    }
                    case Assignment: {
                        value = cell.getValue();
                        if (value == null) break;
                        Action action = new VariableAssignAction();
                        ((AbstractAction)action).setPriority(1000 - column.getNum());
                        ((VariableAssignAction)action).setValue(value);
                        ((VariableAssignAction)action).setDatatype(column.getDatatype());
                        ((VariableAssignAction)action).setVariableName(column.getVariableName());
                        ((VariableAssignAction)action).setCategoryUuid(column.getCategoryUuid());
                        ((VariableAssignAction)action).setUuid(column.getUuid());
                        ((VariableAssignAction)action).setVariableLabel(column.getVariableLabel());
                        ((VariableAssignAction)action).setVariableCategory(column.getVariableCategory());
                        ((VariableAssignAction)action).setKeyLabel(column.getKeyLabel());
                        ((VariableAssignAction)action).setKeyName(column.getKeyName());
                        ((VariableAssignAction)action).setKeyCategoryUuid(column.getKeyCategoryUuid());
                        ((VariableAssignAction)action).setKeyUuid(column.getKeyUuid());
                        rhs.addAction(action);
                        break;
                    }
                    case ExecuteMethod: {
                        Action action = cell.getAction();
                        if (action == null) break;
                        AbstractAction abstractAction = (AbstractAction)action;
                        abstractAction.setPriority(1000 - column.getNum());
                        rhs.addAction(abstractAction);
                    }
                }
            }
            if (and.getCriterions() == null) continue;
            lhs.setCriterion(and);
        }
        return arrayList;
    }

    private Cell a(DecisionTable decisionTable, int n, int n2) {
        Map<String, Cell> map = decisionTable.getCellMap();
        Cell cell = null;
        for (int i = n; i > -1; --i) {
            String string = decisionTable.buildCellKey(i, n2);
            if (!map.containsKey(string)) continue;
            cell = map.get(string);
            break;
        }
        if (cell == null) {
            throw new RuleException("Decision table cell[" + n + "," + n2 + "] not exist.");
        }
        return cell;
    }

    public void setCellContentBuilder(CellContentBuilder cellContentBuilder) {
        this.a = cellContentBuilder;
    }
}

