/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.builder.table;

import com.bstek.urule.builder.table.CellScriptDSLBuilder;
import com.bstek.urule.dsl.DSLRuleSetBuilder;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.LibraryType;
import com.bstek.urule.model.rule.RuleSet;
import com.bstek.urule.model.table.Column;
import com.bstek.urule.model.table.ColumnType;
import com.bstek.urule.model.table.Row;
import com.bstek.urule.model.table.ScriptCell;
import com.bstek.urule.model.table.ScriptDecisionTable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ScriptDecisionTableRulesBuilder {
    private CellScriptDSLBuilder a;
    private DSLRuleSetBuilder b;

    public RuleSet buildRules(ScriptDecisionTable scriptDecisionTable, String string) throws IOException {
        List<Row> list = scriptDecisionTable.getRows();
        List<Column> list2 = scriptDecisionTable.getColumns();
        List<Library> list3 = scriptDecisionTable.getLibraries();
        StringBuffer stringBuffer = this.a(list3);
        for (Row row : list) {
            stringBuffer.append("rule \"r" + row.getNum() + "\"");
            stringBuffer.append("\r\n");
            stringBuffer.append("if");
            stringBuffer.append("\r\n");
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            for (Column column : list2) {
                ScriptCell scriptCell = this.a(scriptDecisionTable, row.getNum(), column.getNum());
                String string2 = scriptCell.getScript();
                if (StringUtils.isBlank((String)string2)) continue;
                ColumnType columnType = column.getType();
                switch (columnType) {
                    case Criteria: {
                        String string3 = column.getVariableCategory() + "." + column.getVariableLabel();
                        String string4 = this.a.buildCriteriaScript(string2, string3);
                        if (StringUtils.isBlank((String)string4)) break;
                        string4 = string4.trim();
                        if (stringBuffer2.length() > 1) {
                            stringBuffer2.append(" and ");
                        }
                        if (!string4.startsWith("(")) {
                            string4 = "(" + string4 + ")";
                        }
                        stringBuffer2.append(string4);
                        break;
                    }
                    case ConsolePrint: {
                        stringBuffer3.append("out(" + string2 + ");\r\n");
                        break;
                    }
                    case Assignment: {
                        String string3 = column.getVariableCategory() + "." + column.getVariableLabel();
                        stringBuffer3.append(string3 + " = " + string2 + ";\r\n");
                        break;
                    }
                    case ExecuteMethod: {
                        stringBuffer3.append(string2 + ";\r\n");
                    }
                }
            }
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("\r\n");
            stringBuffer.append("then");
            stringBuffer.append("\r\n");
            stringBuffer.append(stringBuffer3);
            stringBuffer.append("\r\n");
            stringBuffer.append("end;");
            stringBuffer.append("\r\n");
        }
        RuleSet ruleSet = this.b.build(stringBuffer.toString(), string);
        return ruleSet;
    }

    private StringBuffer a(List<Library> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Library library : list) {
            LibraryType libraryType = library.getType();
            switch (libraryType) {
                case Action: {
                    stringBuffer.append("importActionLibrary \"" + library.getPath() + "\";\r\n");
                    break;
                }
                case Constant: {
                    stringBuffer.append("importConstantLibrary \"" + library.getPath() + "\";\r\n");
                    break;
                }
                case Parameter: {
                    stringBuffer.append("importParameterLibrary \"" + library.getPath() + "\";\r\n");
                    break;
                }
                case Variable: {
                    stringBuffer.append("importVariableLibrary \"" + library.getPath() + "\";\r\n");
                }
            }
        }
        return stringBuffer;
    }

    private ScriptCell a(ScriptDecisionTable scriptDecisionTable, int n, int n2) {
        Map<String, ScriptCell> map = scriptDecisionTable.getCellMap();
        ScriptCell scriptCell = null;
        for (int i = n; i > -1; --i) {
            String string = scriptDecisionTable.buildCellKey(i, n2);
            if (!map.containsKey(string)) continue;
            scriptCell = map.get(string);
            break;
        }
        if (scriptCell == null) {
            throw new RuleException("Decision table cell[" + n + "," + n2 + "] not exist.");
        }
        return scriptCell;
    }

    public void setCellScriptDSLBuilder(CellScriptDSLBuilder cellScriptDSLBuilder) {
        this.a = cellScriptDSLBuilder;
    }

    public void setDslRuleSetBuilder(DSLRuleSetBuilder dSLRuleSetBuilder) {
        this.b = dSLRuleSetBuilder;
    }
}

