/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.dbstore.manager;

import com.bstek.urule.PropertyConfigurer;
import com.bstek.urule.dbstore.DatabaseStore;
import com.bstek.urule.dbstore.MssqlDatabaseStore;
import com.bstek.urule.dbstore.MysqlDatabaseStore;
import com.bstek.urule.dbstore.OracleDatabaseStore;
import com.bstek.urule.dbstore.service.DatabaseKnowledgePackageFileService;
import com.bstek.urule.dbstore.service.DbService;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.runtime.service.KnowledgePackageFileService;
import com.bstek.urule.runtime.service.KnowledgeServiceImpl;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class KnowledgePackageManager
implements ApplicationContextAware {
    public static final String BEAN_ID = "urule.dbstore.knowledgePackageManager";
    private static final String a = "urule.knowledgePackageDatabaseStore.dataSource";
    private DataSource b;
    private static List<DatabaseStore> c = new ArrayList<DatabaseStore>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeKnowledgePackage(String string) throws Exception {
        Connection connection = this.a();
        Statement statement = null;
        String string2 = "DELETE FROM URULE_KP_STORE where ID_=?";
        try {
            statement = connection.createStatement();
            int n = statement.executeUpdate(string2);
            return n;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveKnowledgePackage(InputStream inputStream, String string, String string2) throws Exception {
        String string3 = "SELECT count(*) FROM URULE_KP_STORE WHERE ID_=?";
        Connection connection = this.a();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            int n = 0;
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
            if (n > 0) {
                string3 = "UPDATE URULE_KP_STORE SET UPDATE_DATE_=?,CREATE_USER_=?,DATA_=? WHERE ID_=?";
                preparedStatement = connection.prepareStatement(string3);
                preparedStatement.setLong(1, new Date().getTime());
                preparedStatement.setString(2, string2);
                preparedStatement.setBlob(3, inputStream);
                preparedStatement.setString(4, string);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                boolean bl = false;
                return bl;
            }
            string3 = "INSERT INTO URULE_KP_STORE(ID_,UPDATE_DATE_,CREATE_USER_,DATA_) VALUES(?,?,?,?)";
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, new Date().getTime());
            preparedStatement.setString(3, string2);
            preparedStatement.setBlob(4, inputStream);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            boolean bl = true;
            return bl;
        }
        finally {
            if (preparedStatement != null && !preparedStatement.isClosed()) {
                preparedStatement.close();
            }
            connection.close();
        }
    }

    private Connection a() throws SQLException {
        return this.b.getConnection();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Object object;
        String string = PropertyConfigurer.getProperty(a);
        if (StringUtils.isBlank((String)string) || !applicationContext.containsBean(string)) {
            return;
        }
        this.b = (DataSource)applicationContext.getBean(string);
        String string2 = null;
        DbService dbService = null;
        Connection connection = null;
        try {
            connection = this.b.getConnection();
            object = connection.getMetaData();
            string2 = object.getDatabaseProductName();
            for (DatabaseStore databaseStore : c) {
                if (!databaseStore.support(string2)) continue;
                System.out.println(">>>\u521d\u59cb\u5316" + string2 + "\u6570\u636e\u5e93\u4e2d\u77e5\u8bc6\u5305\u5b58\u50a8\u8868,\u76ee\u6807\u6570\u636e\u5e93\u4e2d\u5982\u4e0d\u5b58\u5728\u77e5\u8bc6\u5305\u5b58\u50a8\u8868\u5c06\u4f1a\u81ea\u52a8\u521b\u5efa...");
                databaseStore.init(this.b);
                dbService = databaseStore.getDbService();
                break;
            }
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        if (dbService != null) {
            object = new DatabaseKnowledgePackageFileService(dbService);
            KnowledgeServiceImpl knowledgeServiceImpl = (KnowledgeServiceImpl)applicationContext.getBean("urule.knowledgeService");
            knowledgeServiceImpl.setKnowledgePackageFileService((KnowledgePackageFileService)object);
        } else {
            System.out.println(">>>\u77e5\u8bc6\u5305\u6570\u636e\u5b58\u50a8\u4e0d\u652f\u6301\u5f53\u524d\u6570\u636e\u7c7b\u578b\u3010" + string2 + "\u3011...");
        }
    }

    static {
        c.add(new MysqlDatabaseStore());
        c.add(new OracleDatabaseStore());
        c.add(new MssqlDatabaseStore());
    }
}

