/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.dbstore.service;

import com.bstek.urule.Utils;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.KnowledgePackageImpl;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;

public abstract class DbService {
    private DataSource a;

    public DbService(DataSource dataSource) {
        this.a = dataSource;
    }

    public DataSource getDataSource() {
        return this.a;
    }

    public KnowledgePackage loadKnowledgePackage(String string) {
        Connection connection = null;
        try {
            connection = this.a();
            KnowledgePackage knowledgePackage = this.a(string, connection);
            return knowledgePackage;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public KnowledgePackage verifyKnowledgePackage(String string, long l) {
        KnowledgePackage knowledgePackage;
        String string2 = "SELECT count(*) FROM URULE_KP_STORE WHERE ID_=? AND UPDATE_DATE_=?";
        Connection connection = null;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.a();
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, l);
            resultSet = preparedStatement.executeQuery();
            int n = 0;
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            if (n > 0) {
                KnowledgePackage knowledgePackage2 = null;
                return knowledgePackage2;
            }
            knowledgePackage = this.a(string, connection);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return knowledgePackage;
    }

    protected Connection a() throws SQLException {
        return this.a.getConnection();
    }

    protected KnowledgePackage a(String string, Connection connection) throws SQLException, IOException {
        block6: {
            KnowledgePackageImpl knowledgePackageImpl;
            InputStream inputStream;
            ResultSet resultSet;
            block7: {
                String string2 = "select DATA_,UPDATE_DATE_ from URULE_KP_STORE where ID_=?";
                resultSet = null;
                PreparedStatement preparedStatement = null;
                inputStream = null;
                try {
                    preparedStatement = connection.prepareStatement(string2);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block6;
                    Blob blob = resultSet.getBlob(1);
                    inputStream = blob.getBinaryStream();
                    String string3 = Utils.uncompress(IOUtils.toByteArray((InputStream)inputStream));
                    KnowledgePackage knowledgePackage = Utils.stringToKnowledgePackage(string3);
                    KnowledgePackageImpl knowledgePackageImpl2 = (KnowledgePackageImpl)knowledgePackage;
                    knowledgePackageImpl2.setPackageInfo(string);
                    long l = resultSet.getLong(2);
                    knowledgePackageImpl2.setTimestamp(l);
                    knowledgePackageImpl = knowledgePackageImpl2;
                    if (preparedStatement == null) break block7;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                preparedStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return knowledgePackageImpl;
        }
        throw new RuleException("\u672a\u5728\u6570\u636e\u5e93\u4e2d\u627e\u5230\u5b58\u50a8\u7684\u77e5\u8bc6\u5305\u3010" + string + "\u3011");
    }
}

