/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model;

import com.bstek.urule.Configure;
import com.bstek.urule.Utils;
import com.bstek.urule.action.AbstractAction;
import com.bstek.urule.action.Action;
import com.bstek.urule.action.ActionType;
import com.bstek.urule.action.ConsolePrintAction;
import com.bstek.urule.action.ExecuteCommonFunctionAction;
import com.bstek.urule.action.ExecuteMethodAction;
import com.bstek.urule.action.InvokeFile;
import com.bstek.urule.action.InvokeKnowledgePackage;
import com.bstek.urule.action.ScoringAction;
import com.bstek.urule.action.VariableAssignAction;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rete.JsonUtils;
import com.bstek.urule.model.rule.Other;
import com.bstek.urule.model.rule.Rhs;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.lhs.LeftType;
import com.bstek.urule.model.rule.loop.LoopEnd;
import com.bstek.urule.model.rule.loop.LoopRule;
import com.bstek.urule.model.rule.loop.LoopStart;
import com.bstek.urule.model.rule.loop.LoopTarget;
import com.bstek.urule.model.rule.loop.LoopTargetType;
import com.bstek.urule.model.scorecard.AssignTargetType;
import com.bstek.urule.model.scorecard.ScoringType;
import com.bstek.urule.model.scorecard.runtime.ScoreRule;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractJsonDeserializer<T>
extends JsonDeserializer<T> {
    protected Rule parseRule(JsonParser jsonParser, JsonNode jsonNode) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Configure.getDateFormat());
        try {
            JsonNode jsonNode2;
            String string;
            String string2;
            String string3;
            String string4;
            Object object;
            Object object2;
            Object object3;
            JsonNode jsonNode3 = jsonNode.get("rule");
            if (jsonNode3 == null) {
                jsonNode3 = jsonNode;
            }
            Rule rule = null;
            String string5 = JsonUtils.getJsonValue(jsonNode3, "scoringType");
            if (StringUtils.isNotBlank((String)string5)) {
                object3 = ScoringType.valueOf(string5);
                object2 = new ScoreRule();
                ((ScoreRule)object2).setScoringType((ScoringType)((Object)object3));
                this.buildScoreRule(jsonParser, jsonNode3, (ScoreRule)object2);
                rule = object2;
            } else {
                object3 = JsonUtils.getJsonValue(jsonNode3, "loopRule");
                if (object3 != null) {
                    boolean bl = Boolean.valueOf((String)object3);
                    if (bl) {
                        object = new LoopRule();
                        this.buildLoopRule(jsonNode3, (LoopRule)object);
                        rule = object;
                    } else {
                        rule = new Rule();
                    }
                } else {
                    rule = new Rule();
                }
            }
            object3 = JsonUtils.getJsonValue(jsonNode3, "withElse");
            if (StringUtils.isNotBlank((String)object3)) {
                rule.setWithElse(Boolean.valueOf((String)object3));
            }
            rule.setRemark(JsonUtils.getJsonValue(jsonNode3, "remark"));
            rule.setMutexGroup(JsonUtils.getJsonValue(jsonNode3, "mutexGroup"));
            rule.setPendedGroup(JsonUtils.getJsonValue(jsonNode3, "pendedGroup"));
            object2 = JsonUtils.getJsonValue(jsonNode3, "autoFocus");
            if (object2 != null) {
                rule.setAutoFocus(Boolean.valueOf((String)object2));
            }
            if ((object = JsonUtils.getJsonValue(jsonNode3, "loop")) != null) {
                rule.setLoop(Boolean.valueOf((String)object));
            }
            if ((string4 = JsonUtils.getJsonValue(jsonNode3, "effectiveDate")) != null) {
                rule.setEffectiveDate(simpleDateFormat.parse(string4));
            }
            if ((string3 = JsonUtils.getJsonValue(jsonNode3, "enabled")) != null) {
                rule.setEnabled(Boolean.valueOf(string3));
            }
            if ((string2 = JsonUtils.getJsonValue(jsonNode3, "debug")) != null) {
                rule.setDebug(Boolean.valueOf(string2));
            }
            if ((string = JsonUtils.getJsonValue(jsonNode3, "expiresDate")) != null) {
                rule.setExpiresDate(simpleDateFormat.parse(string));
            }
            rule.setName(JsonUtils.getJsonValue(jsonNode3, "name"));
            rule.setFile(JsonUtils.getJsonValue(jsonNode3, "file"));
            String string6 = JsonUtils.getJsonValue(jsonNode3, "salience");
            if (string6 != null) {
                rule.setSalience(Integer.valueOf(string6));
            }
            Rhs rhs = new Rhs();
            rule.setRhs(rhs);
            JsonNode jsonNode4 = jsonNode3.get("rhs");
            if (jsonNode4 != null) {
                rhs.setActions(this.parseActions(jsonNode4));
            }
            if ((jsonNode2 = jsonNode3.get("other")) != null) {
                Other other = new Other();
                rule.setOther(other);
                other.setActions(this.parseActions(jsonNode2));
            }
            if (rule.isWithElse()) {
                Utils.buildElseRule(rule);
            }
            return rule;
        }
        catch (ParseException parseException) {
            throw new RuleException(parseException);
        }
    }

    private void buildScoreRule(JsonParser jsonParser, JsonNode jsonNode, ScoreRule scoreRule) {
        scoreRule.setScoringBean(JsonUtils.getJsonValue(jsonNode, "scoringBean"));
        AssignTargetType assignTargetType = AssignTargetType.valueOf(JsonUtils.getJsonValue(jsonNode, "assignTargetType"));
        scoreRule.setAssignTargetType(assignTargetType);
        scoreRule.setVariableCategory(JsonUtils.getJsonValue(jsonNode, "variableCategory"));
        scoreRule.setVariableName(JsonUtils.getJsonValue(jsonNode, "variableName"));
        scoreRule.setVariableLabel(JsonUtils.getJsonValue(jsonNode, "variableLabel"));
        scoreRule.setKeyLabel(JsonUtils.getJsonValue(jsonNode, "keyLabel"));
        scoreRule.setKeyName(JsonUtils.getJsonValue(jsonNode, "keyName"));
        String string = JsonUtils.getJsonValue(jsonNode, "datatype");
        if (StringUtils.isNotBlank((String)string)) {
            scoreRule.setDatatype(Datatype.valueOf(string));
        }
        try {
            JsonNode jsonNode2 = jsonNode.get("knowledgePackageWrapper");
            ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
            KnowledgePackageWrapper knowledgePackageWrapper = (KnowledgePackageWrapper)objectMapper.convertValue((Object)jsonNode2, KnowledgePackageWrapper.class);
            knowledgePackageWrapper.buildDeserialize();
            scoreRule.setKnowledgePackageWrapper(knowledgePackageWrapper);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    private void buildLoopRule(JsonNode jsonNode, LoopRule loopRule) {
        Object object;
        Object object2;
        Object object3;
        LoopTarget loopTarget;
        JsonNode jsonNode2 = jsonNode.get("loopTarget");
        String string = JsonUtils.getJsonValue(jsonNode, "loopTargetType");
        if (StringUtils.isNotBlank((String)string)) {
            loopRule.setLoopTargetType(LoopTargetType.valueOf(string));
        }
        if (jsonNode2 != null) {
            loopTarget = new LoopTarget();
            object3 = JsonUtils.parseValue(jsonNode2);
            loopTarget.setValue((Value)object3);
            loopRule.setLoopTarget(loopTarget);
        }
        if ((loopTarget = jsonNode.get("loopStart")) != null) {
            object3 = this.parseActions((JsonNode)loopTarget);
            object2 = new LoopStart();
            ((LoopStart)object2).setActions((List<Action>)object3);
            loopRule.setLoopStart((LoopStart)object2);
        }
        if ((object3 = jsonNode.get("loopEnd")) != null) {
            object2 = this.parseActions((JsonNode)object3);
            object = new LoopEnd();
            ((LoopEnd)object).setActions((List<Action>)object2);
            loopRule.setLoopEnd((LoopEnd)object);
        }
        if ((object2 = jsonNode.get("knowledgePackageWrapper")) != null) {
            object = JsonUtils.parseKnowledgePackageWrapper(object2.toString());
            loopRule.setKnowledgePackageWrapper((KnowledgePackageWrapper)object);
        }
    }

    private List<Action> parseActions(JsonNode jsonNode) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        JsonNode jsonNode2 = jsonNode.get("actions");
        if (jsonNode2 == null) {
            return arrayList;
        }
        for (JsonNode jsonNode3 : jsonNode2) {
            ActionType actionType = ActionType.valueOf(JsonUtils.getJsonValue(jsonNode3, "actionType"));
            switch (actionType) {
                case ConsolePrint: {
                    ConsolePrintAction consolePrintAction = new ConsolePrintAction();
                    consolePrintAction.setValue(JsonUtils.parseValue(jsonNode3));
                    consolePrintAction.setPriority(Integer.valueOf(JsonUtils.getJsonValue(jsonNode3, "priority")));
                    arrayList.add(consolePrintAction);
                    break;
                }
                case ExecuteMethod: {
                    Object object;
                    String string;
                    Object object2;
                    long l;
                    String string2;
                    Object object3;
                    String string3;
                    ExecuteMethodAction executeMethodAction = new ExecuteMethodAction();
                    executeMethodAction.setBeanId(JsonUtils.getJsonValue(jsonNode3, "beanId"));
                    executeMethodAction.setBeanLabel(JsonUtils.getJsonValue(jsonNode3, "beanLabel"));
                    executeMethodAction.setMethodLabel(JsonUtils.getJsonValue(jsonNode3, "methodLabel"));
                    executeMethodAction.setPriority(Integer.valueOf(JsonUtils.getJsonValue(jsonNode3, "priority")));
                    executeMethodAction.setMethodName(JsonUtils.getJsonValue(jsonNode3, "methodName"));
                    executeMethodAction.setParameters(JsonUtils.parseParameters(jsonNode3));
                    JsonNode jsonNode4 = jsonNode3.get("invokeKnowledgePackage");
                    if (jsonNode4 != null) {
                        string3 = JsonUtils.getJsonValue(jsonNode4, "project");
                        object3 = JsonUtils.getJsonValue(jsonNode4, "name");
                        string2 = JsonUtils.getJsonValue(jsonNode4, "code");
                        l = Long.valueOf(JsonUtils.getJsonValue(jsonNode4, "id"));
                        executeMethodAction.setInvokeKnowledgePackage(new InvokeKnowledgePackage(string3, (String)object3, l, string2));
                    }
                    if ((string3 = jsonNode3.get("invokeFile")) != null) {
                        object3 = JsonUtils.getJsonValue((JsonNode)string3, "path");
                        string2 = JsonUtils.getJsonValue((JsonNode)string3, "version");
                        l = Long.valueOf(JsonUtils.getJsonValue((JsonNode)string3, "id"));
                        object2 = new InvokeFile();
                        ((InvokeFile)object2).setId(l);
                        ((InvokeFile)object2).setPath((String)object3);
                        ((InvokeFile)object2).setVersion(string2);
                        executeMethodAction.setInvokeFile((InvokeFile)object2);
                        string = string3.get("knowledgePackageWrapper");
                        if (string != null) {
                            object = JsonUtils.parseKnowledgePackageWrapper(string.toString());
                            ((InvokeFile)object2).setKnowledgePackageWrapper((KnowledgePackageWrapper)object);
                        }
                    }
                    arrayList.add(executeMethodAction);
                    break;
                }
                case VariableAssign: {
                    Object object3 = new VariableAssignAction();
                    String string2 = JsonUtils.getJsonValue(jsonNode3, "type");
                    if (string2 != null) {
                        ((VariableAssignAction)object3).setType(LeftType.valueOf(string2));
                    }
                    ((VariableAssignAction)object3).setDatatype(Datatype.valueOf(JsonUtils.getJsonValue(jsonNode3, "datatype")));
                    ((VariableAssignAction)object3).setVariableCategory(JsonUtils.getJsonValue(jsonNode3, "variableCategory"));
                    ((VariableAssignAction)object3).setCategoryUuid(JsonUtils.getJsonValue(jsonNode3, "categoryUuid"));
                    ((VariableAssignAction)object3).setVariableLabel(JsonUtils.getJsonValue(jsonNode3, "variableLabel"));
                    ((VariableAssignAction)object3).setVariableName(JsonUtils.getJsonValue(jsonNode3, "variableName"));
                    ((VariableAssignAction)object3).setUuid(JsonUtils.getJsonValue(jsonNode3, "uuid"));
                    ((VariableAssignAction)object3).setKeyLabel(JsonUtils.getJsonValue(jsonNode3, "keyLabel"));
                    ((VariableAssignAction)object3).setKeyName(JsonUtils.getJsonValue(jsonNode3, "keyName"));
                    ((VariableAssignAction)object3).setKeyUuid(JsonUtils.getJsonValue(jsonNode3, "keyUuid"));
                    ((VariableAssignAction)object3).setKeyCategoryUuid(JsonUtils.getJsonValue(jsonNode3, "keyCategoryUuid"));
                    ((AbstractAction)object3).setPriority(Integer.valueOf(JsonUtils.getJsonValue(jsonNode3, "priority")));
                    ((VariableAssignAction)object3).setValue(JsonUtils.parseValue(jsonNode3));
                    arrayList.add((Action)object3);
                    break;
                }
                case ExecuteCommonFunction: {
                    ExecuteCommonFunctionAction executeCommonFunctionAction = new ExecuteCommonFunctionAction();
                    executeCommonFunctionAction.setLabel(JsonUtils.getJsonValue(jsonNode3, "label"));
                    executeCommonFunctionAction.setName(JsonUtils.getJsonValue(jsonNode3, "name"));
                    executeCommonFunctionAction.setParameter(JsonUtils.parseCommonFunctionParameter(jsonNode3));
                    executeCommonFunctionAction.setPriority(Integer.valueOf(JsonUtils.getJsonValue(jsonNode3, "priority")));
                    arrayList.add(executeCommonFunctionAction);
                    break;
                }
                case Scoring: {
                    int n = Integer.valueOf(JsonUtils.getJsonValue(jsonNode3, "rowNumber"));
                    Object object2 = JsonUtils.getJsonValue(jsonNode3, "name");
                    String string = JsonUtils.getJsonValue(jsonNode3, "weight");
                    Object object = new ScoringAction(n, (String)object2, string);
                    ((ScoringAction)object).setValue(JsonUtils.parseValue(jsonNode3));
                    arrayList.add((Action)object);
                    break;
                }
                case TemplateAction: {
                    throw new RuleException("Unsupport action type:" + (Object)((Object)ActionType.TemplateAction));
                }
            }
        }
        return arrayList;
    }
}

