/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.flow;

import com.bstek.urule.Utils;
import com.bstek.urule.action.Action;
import com.bstek.urule.action.VariableAssignAction;
import com.bstek.urule.model.flow.BindingNode;
import com.bstek.urule.model.flow.Branch;
import com.bstek.urule.model.flow.DecisionItem;
import com.bstek.urule.model.flow.DecisionType;
import com.bstek.urule.model.flow.EventType;
import com.bstek.urule.model.flow.FlowDefinition;
import com.bstek.urule.model.flow.FlowNodeType;
import com.bstek.urule.model.flow.PercentItem;
import com.bstek.urule.model.flow.PercentScope;
import com.bstek.urule.model.flow.ins.FlowContext;
import com.bstek.urule.model.flow.ins.FlowInstance;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.Rhs;
import com.bstek.urule.model.rule.Rule;
import com.bstek.urule.model.rule.RuleSet;
import com.bstek.urule.model.rule.SimpleValue;
import com.bstek.urule.model.rule.lhs.LeftType;
import com.bstek.urule.runtime.KnowledgeSession;
import com.bstek.urule.runtime.percent.PercentDataStore;
import com.bstek.urule.runtime.percent.PercentUnit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class DecisionNode
extends BindingNode {
    private final Logger log = Logger.getLogger(DecisionNode.class.getName());
    private List<DecisionItem> items;
    private FlowNodeType type = FlowNodeType.Decision;
    private DecisionType decisionType = DecisionType.Criteria;
    private PercentScope percentScope;

    public DecisionNode() {
    }

    public DecisionNode(String string) {
        super(string);
    }

    @Override
    public void enterNode(Exception exception, FlowContext flowContext, FlowInstance flowInstance) {
        flowInstance.setCurrentNode(this);
        if (this.decisionType.equals((Object)DecisionType.Criteria)) {
            this.doCriteria(flowContext, flowInstance);
        } else {
            this.doPercent(flowContext, flowInstance);
        }
        this.executeNodeEvent(EventType.enter, flowContext, flowInstance);
    }

    private void doPercent(FlowContext flowContext, FlowInstance flowInstance) {
        if (this.percentScope == null || this.percentScope.equals((Object)PercentScope.batch)) {
            this.doBatchScope(flowContext, flowInstance);
        } else {
            this.doGlobalScope(flowContext, flowInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBatchScope(FlowContext flowContext, FlowInstance flowInstance) {
        Exception exception = null;
        PercentItem percentItem = null;
        try {
            String string = flowInstance.getProcessDefinition().getId() + "_" + this.name;
            long l = this.getAmount(string, flowContext) + 1L;
            ArrayList<PercentItem> arrayList = new ArrayList<PercentItem>();
            for (DecisionItem decisionItem : this.items) {
                PercentItem percentItem2 = new PercentItem();
                percentItem2.setName(decisionItem.getTo());
                percentItem2.setPercent(decisionItem.getPercent());
                String string2 = string + "." + decisionItem.getTo();
                long l2 = this.getAmount(string2, flowContext);
                percentItem2.setTotal(l2);
                arrayList.add(percentItem2);
            }
            percentItem = this.computePercent(arrayList, l);
            this.setAmount(string, l, flowContext);
            this.setAmount(string + "." + percentItem.getName(), percentItem.getTotal() + 1L, flowContext);
            this.executeNodeEvent(EventType.leave, flowContext, flowInstance);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        finally {
            this.leave(percentItem.getName(), flowContext, flowInstance, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGlobalScope(FlowContext flowContext, FlowInstance flowInstance) {
        Exception exception = null;
        PercentItem percentItem = null;
        try {
            Object object;
            PercentDataStore percentDataStore = (PercentDataStore)Utils.getApplicationContext().getBean("urule.percentDataStore");
            PercentUnit percentUnit = percentDataStore.getDecisionNodePercent(flowInstance.getProcessDefinition(), this.items, this.name);
            ArrayList<PercentItem> arrayList = new ArrayList<PercentItem>();
            for (DecisionItem decisionItem : this.items) {
                object = new PercentItem();
                ((PercentItem)object).setName(decisionItem.getTo());
                ((PercentItem)object).setPercent(decisionItem.getPercent());
                long l = percentUnit.getBranch(decisionItem).getTotal();
                ((PercentItem)object).setTotal(l);
                ((PercentItem)object).setItem(decisionItem);
                arrayList.add((PercentItem)object);
            }
            long l = percentUnit.getTotal() + 1L;
            percentItem = this.computePercent(arrayList, l);
            percentUnit.setTotal(l);
            object = percentUnit.getBranch(percentItem.getItem());
            ((Branch)object).setTotal(percentItem.getTotal() + 1L);
            this.executeNodeEvent(EventType.leave, flowContext, flowInstance);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        finally {
            this.leave(percentItem.getName(), flowContext, flowInstance, exception);
        }
    }

    private long getAmount(String string, FlowContext flowContext) {
        Object object = flowContext.getWorkingMemory().getSessionValue(string);
        if (object == null) {
            return 0L;
        }
        return (Long)object;
    }

    private void setAmount(String string, long l, FlowContext flowContext) {
        flowContext.getWorkingMemory().setSessionValue(string, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCriteria(FlowContext flowContext, FlowInstance flowInstance) {
        String string;
        KnowledgeSession knowledgeSession;
        Exception exception;
        Object object;
        block5: {
            object = null;
            exception = null;
            knowledgeSession = this.executeKnowledgePackage(flowContext, flowInstance);
            this.executeNodeEvent(EventType.leave, flowContext, flowInstance);
            object = knowledgeSession.getParameter("return_to__");
            string = flowInstance.getProcessDefinition().getFile();
            if (object != null) break block5;
            flowContext.getLogger().logDecisionNodeMatch(this, string, null);
            this.log.warning("Decision node [" + this.getName() + "] no matching conditions.");
            this.leave(object != null ? object.toString() : null, flowContext, flowInstance, exception);
            return;
        }
        try {
            flowContext.getLogger().logDecisionNodeMatch(this, string, object.toString());
            knowledgeSession.getParameters().remove("return_to__");
            this.leave(object != null ? object.toString() : null, flowContext, flowInstance, exception);
        }
        catch (Exception exception2) {
            try {
                exception = exception2;
                this.leave(object != null ? object.toString() : null, flowContext, flowInstance, exception);
            }
            catch (Throwable throwable) {
                this.leave(object != null ? object.toString() : null, flowContext, flowInstance, exception);
                throw throwable;
            }
        }
    }

    private PercentItem computePercent(List<PercentItem> list, long l) {
        BigDecimal bigDecimal = new BigDecimal(l);
        for (PercentItem percentItem : list) {
            long l2 = percentItem.getTotal();
            BigDecimal bigDecimal2 = new BigDecimal(l2);
            BigDecimal bigDecimal3 = bigDecimal2.divide(bigDecimal, 20, 6);
            BigDecimal bigDecimal4 = new BigDecimal(percentItem.getPercent());
            int n = bigDecimal3.compareTo(bigDecimal4 = bigDecimal4.divide(new BigDecimal(100), 2, 6));
            if (n != -1) continue;
            return percentItem;
        }
        return list.get(0);
    }

    @Override
    public FlowNodeType getType() {
        return this.type;
    }

    public List<DecisionItem> getItems() {
        return this.items;
    }

    public void setItems(List<DecisionItem> list) {
        this.items = list;
    }

    public RuleSet buildRuleSet(List<Library> list, FlowDefinition flowDefinition) {
        RuleSet ruleSet = new RuleSet();
        ruleSet.setLibraries(list);
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        ruleSet.setRules(arrayList);
        int n = 0;
        for (DecisionItem decisionItem : this.items) {
            ++n;
            if (decisionItem.getConditionType() == null || decisionItem.getConditionType().equals("script")) continue;
            Rule rule = new Rule();
            arrayList.add(rule);
            rule.setFile(flowDefinition.getFile());
            rule.setLhs(decisionItem.getLhs());
            rule.setDebug(flowDefinition.isDebug());
            rule.setName("\u51b3\u7b56\u8282\u70b9[" + this.getName() + "]-" + n);
            Rhs rhs = new Rhs();
            rule.setRhs(rhs);
            ArrayList<Action> arrayList2 = new ArrayList<Action>();
            rhs.setActions(arrayList2);
            VariableAssignAction variableAssignAction = new VariableAssignAction();
            arrayList2.add(variableAssignAction);
            variableAssignAction.setDatatype(Datatype.String);
            variableAssignAction.setDebug(flowDefinition.isDebug());
            variableAssignAction.setCategoryUuid("\u53c2\u6570");
            variableAssignAction.setVariableCategory("parameter");
            variableAssignAction.setVariableLabel("return_to__");
            variableAssignAction.setVariableName("return_to__");
            variableAssignAction.setType(LeftType.variable);
            SimpleValue simpleValue = new SimpleValue();
            simpleValue.setContent(decisionItem.getTo());
            variableAssignAction.setValue(simpleValue);
        }
        return ruleSet;
    }

    public PercentScope getPercentScope() {
        return this.percentScope;
    }

    public void setPercentScope(PercentScope percentScope) {
        this.percentScope = percentScope;
    }

    public DecisionType getDecisionType() {
        return this.decisionType;
    }

    public void setDecisionType(DecisionType decisionType) {
        this.decisionType = decisionType;
    }
}

