/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.flow;

import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.flow.EventType;
import com.bstek.urule.model.flow.ExceptionHandler;
import com.bstek.urule.model.flow.FlowNode;
import com.bstek.urule.model.flow.FlowNodeType;
import com.bstek.urule.model.flow.ins.FlowContext;
import com.bstek.urule.model.flow.ins.FlowInstance;
import org.springframework.util.StringUtils;

public class ExceptionNode
extends FlowNode {
    private String exception;
    private String exceptionBean;
    private Class<?> targetException;

    public ExceptionNode() {
    }

    public ExceptionNode(String string, String string2) {
        super(string);
        this.exception = string2;
    }

    @Override
    public void enterNode(Exception exception, FlowContext flowContext, FlowInstance flowInstance) {
        Class<?> clazz;
        if (exception == null) {
            return;
        }
        Class<?> clazz2 = this.buildTargetException();
        if (!clazz2.isAssignableFrom(clazz = exception.getClass())) {
            return;
        }
        if (flowInstance.isDebug()) {
            flowContext.getLogger().logExceptionNode(this, exception, flowInstance.getProcessDefinition().getFile());
        }
        flowInstance.setCurrentNode(this);
        this.executeNodeEvent(EventType.enter, flowContext, flowInstance);
        if (!StringUtils.isEmpty((Object)this.exceptionBean)) {
            ExceptionHandler exceptionHandler = (ExceptionHandler)flowContext.getApplicationContext().getBean(this.exceptionBean);
            exceptionHandler.handle(exception, flowContext, flowInstance);
        }
        this.executeNodeEvent(EventType.leave, flowContext, flowInstance);
        this.leave(null, flowContext, flowInstance, null);
    }

    private synchronized Class<?> buildTargetException() {
        if (this.targetException != null) {
            return this.targetException;
        }
        if (StringUtils.isEmpty((Object)this.exception)) {
            throw new RuleException("\u51b3\u7b56\u6d41\u8282\u70b9\u3010" + this.name + "\u3011\u4e0a\u672a\u6307\u5b9a\u5177\u4f53\u7684\u5f02\u5e38\u7c7b\u8def\u5f84");
        }
        try {
            this.targetException = Class.forName(this.exception);
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
        return this.targetException;
    }

    @Override
    public FlowNodeType getType() {
        return FlowNodeType.Exception;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String string) {
        this.exception = string;
    }

    public String getExceptionBean() {
        return this.exceptionBean;
    }

    public void setExceptionBean(String string) {
        this.exceptionBean = string;
    }
}

