/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.flow;

import com.bstek.urule.builder.KnowledgeBase;
import com.bstek.urule.builder.KnowledgeBuilder;
import com.bstek.urule.builder.ResourceBase;
import com.bstek.urule.dsl.DSLRuleSetBuilder;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.flow.BindingFile;
import com.bstek.urule.model.flow.BindingNode;
import com.bstek.urule.model.flow.Connection;
import com.bstek.urule.model.flow.DecisionItem;
import com.bstek.urule.model.flow.DecisionNode;
import com.bstek.urule.model.flow.DecisionType;
import com.bstek.urule.model.flow.FlowNode;
import com.bstek.urule.model.flow.FlowNodeJsonDeserializer;
import com.bstek.urule.model.flow.ProcessDefinition;
import com.bstek.urule.model.flow.RuleNode;
import com.bstek.urule.model.flow.RulePackageNode;
import com.bstek.urule.model.flow.ScriptNode;
import com.bstek.urule.model.flow.StartNode;
import com.bstek.urule.model.flow.ins.FlowContext;
import com.bstek.urule.model.flow.ins.FlowInstance;
import com.bstek.urule.model.flow.ins.ProcessInstance;
import com.bstek.urule.model.library.ResourceLibrary;
import com.bstek.urule.model.rule.Library;
import com.bstek.urule.model.rule.RuleSet;
import com.bstek.urule.runtime.KnowledgePackage;
import com.bstek.urule.runtime.KnowledgePackageImpl;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import com.bstek.urule.runtime.response.ExecutionResponseImpl;
import com.bstek.urule.runtime.service.KnowledgePackageService;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FlowDefinition
implements ProcessDefinition {
    private String id;
    private boolean debug;
    private String file;
    private List<Library> libraries;
    private String quickTestData;
    @JsonIgnore
    private StartNode startNode;
    @JsonIgnore
    private List<ResourceLibrary> relationResourceLibraries = new ArrayList<ResourceLibrary>();
    @JsonDeserialize(using=FlowNodeJsonDeserializer.class)
    private List<FlowNode> nodes;

    public ProcessInstance newInstance(FlowContext flowContext) {
        long l = System.currentTimeMillis();
        ExecutionResponseImpl executionResponseImpl = (ExecutionResponseImpl)flowContext.getResponse();
        executionResponseImpl.setFlowId(this.id);
        if (this.startNode == null) {
            throw new RuleException("StartNode must be define.");
        }
        FlowInstance flowInstance = new FlowInstance(this, this.debug);
        this.startNode.enter(null, flowContext, flowInstance);
        executionResponseImpl.setDuration(System.currentTimeMillis() - l);
        return flowInstance;
    }

    public void buildConnectionToNode() {
        for (FlowNode flowNode : this.nodes) {
            List<Connection> list = flowNode.getConnections();
            if (list == null || list.size() == 0) continue;
            for (Connection connection : list) {
                String string = connection.getToName();
                connection.setTo(this.getFlowNode(string));
            }
        }
    }

    public void initForActiveVersion() {
        if (this.nodes == null) {
            return;
        }
        for (FlowNode flowNode : this.nodes) {
            BindingNode bindingNode;
            KnowledgePackageWrapper knowledgePackageWrapper;
            if (!(flowNode instanceof BindingNode) || (knowledgePackageWrapper = (bindingNode = (BindingNode)flowNode).getKnowledgePackageWrapper()) == null) continue;
            KnowledgePackageImpl knowledgePackageImpl = (KnowledgePackageImpl)knowledgePackageWrapper.getKnowledgePackage();
            knowledgePackageImpl.initForActiveVersion();
        }
    }

    private FlowNode getFlowNode(String string) {
        for (FlowNode flowNode : this.nodes) {
            if (!flowNode.getName().equals(string)) continue;
            return flowNode;
        }
        throw new RuleException("Flow node [" + string + "] not found.");
    }

    public FlowDefinition newFlowDefinitionForSerialize(KnowledgeBuilder knowledgeBuilder, KnowledgePackageService knowledgePackageService, DSLRuleSetBuilder dSLRuleSetBuilder) throws IOException {
        this.initNodeKnowledgePackage(knowledgeBuilder, knowledgePackageService, dSLRuleSetBuilder);
        FlowDefinition flowDefinition = new FlowDefinition();
        flowDefinition.setLibraries(this.libraries);
        flowDefinition.setId(this.id);
        flowDefinition.setFile(this.file);
        flowDefinition.setDebug(this.debug);
        flowDefinition.setNodes(this.nodes);
        for (FlowNode flowNode : this.nodes) {
            BindingNode bindingNode;
            flowNode.setX(null);
            flowNode.setY(null);
            flowNode.setWidth(null);
            flowNode.setHeight(null);
            if (flowNode instanceof DecisionNode) {
                bindingNode = (DecisionNode)flowNode;
                for (DecisionItem decisionItem : ((DecisionNode)bindingNode).getItems()) {
                    decisionItem.setLhs(null);
                    decisionItem.setLhsXml(null);
                    decisionItem.setScript(null);
                }
            } else if (flowNode instanceof ScriptNode) {
                bindingNode = (ScriptNode)flowNode;
                ((ScriptNode)bindingNode).setActionXml(null);
                ((ScriptNode)bindingNode).setActionsData(null);
            }
            if (!(flowNode instanceof StartNode)) continue;
            flowDefinition.setStartNode((StartNode)flowNode);
        }
        flowDefinition.setRelationResourceLibraries(this.relationResourceLibraries);
        return flowDefinition;
    }

    private void initNodeKnowledgePackage(KnowledgeBuilder knowledgeBuilder, KnowledgePackageService knowledgePackageService, DSLRuleSetBuilder dSLRuleSetBuilder) throws IOException {
        for (FlowNode flowNode : this.nodes) {
            Object object;
            Object object2;
            Object object3;
            if (flowNode instanceof RuleNode) {
                Object object4;
                object3 = knowledgeBuilder.newResourceBase();
                object2 = (RuleNode)flowNode;
                object = ((RuleNode)object2).getFiles();
                Object object5 = object.iterator();
                while (object5.hasNext()) {
                    object4 = object5.next();
                    ((ResourceBase)object3).addResource(((BindingFile)object4).getId(), ((BindingFile)object4).getVersion());
                }
                object5 = knowledgeBuilder.buildKnowledgeBase((ResourceBase)object3);
                object4 = ((KnowledgeBase)object5).getKnowledgePackage();
                if (((KnowledgeBase)object5).getResourceLibrary() != null) {
                    this.relationResourceLibraries.add(((KnowledgeBase)object5).getResourceLibrary());
                }
                ((BindingNode)object2).setKnowledgePackageWrapper(new KnowledgePackageWrapper((KnowledgePackage)object4));
                continue;
            }
            if (flowNode instanceof RulePackageNode) {
                object3 = (RulePackageNode)flowNode;
                object2 = null;
                if (StringUtils.isNotBlank((String)((RulePackageNode)object3).getCode())) {
                    object2 = knowledgePackageService.buildKnowledgePackage(((RulePackageNode)object3).getCode());
                } else {
                    knowledgePackageService.buildKnowledgePackage(((RulePackageNode)object3).getPackageId());
                }
                object = knowledgePackageService.buildKnowledgeBase(((RulePackageNode)object3).getPackageId());
                if (((KnowledgeBase)object).getResourceLibrary() != null) {
                    this.relationResourceLibraries.add(((KnowledgeBase)object).getResourceLibrary());
                }
                ((BindingNode)object3).setKnowledgePackageWrapper(new KnowledgePackageWrapper((KnowledgePackage)object2));
                continue;
            }
            if (flowNode instanceof DecisionNode) {
                object3 = (DecisionNode)flowNode;
                if (!((DecisionNode)object3).getDecisionType().equals((Object)DecisionType.Criteria)) continue;
                object2 = ((DecisionNode)object3).buildRuleSet(this.libraries, this);
                object = knowledgeBuilder.buildKnowledgeBase((RuleSet)object2);
                ((BindingNode)object3).setKnowledgePackageWrapper(new KnowledgePackageWrapper(((KnowledgeBase)object).getKnowledgePackage()));
                continue;
            }
            if (!(flowNode instanceof ScriptNode)) continue;
            object3 = (ScriptNode)flowNode;
            object2 = ((ScriptNode)object3).buildRuleSet(this.libraries, this);
            object = knowledgeBuilder.buildKnowledgeBase((RuleSet)object2);
            ((BindingNode)object3).setKnowledgePackageWrapper(new KnowledgePackageWrapper(((KnowledgeBase)object).getKnowledgePackage()));
        }
    }

    public List<ResourceLibrary> getRelationResourceLibraries() {
        return this.relationResourceLibraries;
    }

    public void setRelationResourceLibraries(List<ResourceLibrary> list) {
        this.relationResourceLibraries = list;
    }

    public void addLibrary(Library library) {
        if (this.libraries == null) {
            this.libraries = new ArrayList<Library>();
        }
        this.libraries.add(library);
    }

    @Override
    public List<Library> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<Library> list) {
        this.libraries = list;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public String getQuickTestData() {
        return this.quickTestData;
    }

    public void setQuickTestData(String string) {
        this.quickTestData = string;
    }

    @Override
    public List<FlowNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<FlowNode> list) {
        if (this.startNode == null) {
            for (FlowNode flowNode : list) {
                if (!(flowNode instanceof StartNode)) continue;
                this.setStartNode((StartNode)flowNode);
                break;
            }
        }
        this.nodes = list;
    }

    public StartNode getStartNode() {
        return this.startNode;
    }

    public void setStartNode(StartNode startNode) {
        this.startNode = startNode;
    }
}

