/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.flow;

import com.bstek.urule.Utils;
import com.bstek.urule.model.Node;
import com.bstek.urule.model.flow.Connection;
import com.bstek.urule.model.flow.DecisionNode;
import com.bstek.urule.model.flow.EventType;
import com.bstek.urule.model.flow.ExceptionNode;
import com.bstek.urule.model.flow.FlowNodeType;
import com.bstek.urule.model.flow.NodeEvent;
import com.bstek.urule.model.flow.ins.FlowContext;
import com.bstek.urule.model.flow.ins.FlowInstance;
import com.bstek.urule.model.flow.ins.ProcessInstance;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;

public abstract class FlowNode
implements Node {
    protected String name;
    protected String eventBean;
    protected String x;
    protected String y;
    protected String width;
    protected String height;
    protected static final String EXCEPTION_DATA = "_node_business_exception_";
    protected List<Connection> connections;

    public FlowNode() {
    }

    public FlowNode(String string) {
        this.name = string;
    }

    public final void enter(Exception exception, FlowContext flowContext, FlowInstance flowInstance) {
        if (exception != null && !(this instanceof ExceptionNode)) {
            return;
        }
        if (flowInstance.isDebug()) {
            flowContext.getLogger().logFlowNode(this, flowInstance.getProcessDefinition().getFile(), true);
        }
        this.enterNode(exception, flowContext, flowInstance);
    }

    public abstract void enterNode(Exception var1, FlowContext var2, FlowInstance var3);

    protected void leave(String string, FlowContext flowContext, FlowInstance flowInstance, Exception exception) {
        this.handleExeption(exception);
        if (flowInstance.isDebug()) {
            flowContext.getLogger().logFlowNode(this, flowInstance.getProcessDefinition().getFile(), false);
        }
        for (Connection connection : this.connections) {
            if (string != null) {
                String string2 = connection.getName();
                String string3 = string2 = string2 == null ? string2 : string2.trim();
                if (!string.trim().equals(string2)) continue;
                connection.execute(exception, flowContext, flowInstance);
                break;
            }
            if (this instanceof DecisionNode) {
                if (exception == null) break;
                connection.execute(exception, flowContext, flowInstance);
                continue;
            }
            connection.execute(exception, flowContext, flowInstance);
            if (exception != null) continue;
            break;
        }
    }

    private void handleExeption(Exception exception) {
        if (exception == null) {
            return;
        }
        boolean bl = false;
        for (Connection connection : this.connections) {
            FlowNode flowNode = connection.getTo();
            if (!(flowNode instanceof ExceptionNode)) continue;
            bl = true;
            break;
        }
        if (bl) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Utils.buildCause(exception, stringBuilder);
        throw new RuntimeException(stringBuilder.toString(), exception);
    }

    protected void executeNodeEvent(EventType eventType, FlowContext flowContext, ProcessInstance processInstance) {
        if (StringUtils.isEmpty((String)this.eventBean)) {
            return;
        }
        ApplicationContext applicationContext = flowContext.getApplicationContext();
        NodeEvent nodeEvent = (NodeEvent)applicationContext.getBean(this.eventBean);
        if (eventType.equals((Object)EventType.enter)) {
            nodeEvent.enter(this, processInstance, flowContext);
        } else {
            nodeEvent.leave(this, processInstance, flowContext);
        }
    }

    public abstract FlowNodeType getType();

    public List<Connection> getConnections() {
        return this.connections;
    }

    public void setConnections(List<Connection> list) {
        this.connections = list;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getEventBean() {
        return this.eventBean;
    }

    public void setEventBean(String string) {
        this.eventBean = string;
    }

    public String getX() {
        return this.x;
    }

    public void setX(String string) {
        this.x = string;
    }

    public String getY() {
        return this.y;
    }

    public void setY(String string) {
        this.y = string;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String string) {
        this.width = string;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String string) {
        this.height = string;
    }
}

