/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.flow;

import com.bstek.urule.PropertyConfigurer;
import com.bstek.urule.model.flow.Connection;
import com.bstek.urule.model.flow.EventType;
import com.bstek.urule.model.flow.FlowNode;
import com.bstek.urule.model.flow.FlowNodeType;
import com.bstek.urule.model.flow.ins.BranchCounter;
import com.bstek.urule.model.flow.ins.FlowContext;
import com.bstek.urule.model.flow.ins.FlowInstance;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;

public class ForkNode
extends FlowNode {
    private String multipleThread;
    private FlowNodeType type = FlowNodeType.Fork;

    public ForkNode() {
    }

    public ForkNode(String string) {
        super(string);
    }

    @Override
    public FlowNodeType getType() {
        return this.type;
    }

    @Override
    public void enterNode(Exception exception, final FlowContext flowContext, final FlowInstance flowInstance) {
        flowInstance.setCurrentNode(this);
        this.executeNodeEvent(EventType.enter, flowContext, flowInstance);
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        for (Connection connection : this.connections) {
            if (!connection.evaluate(flowContext)) continue;
            arrayList.add(connection);
        }
        this.executeNodeEvent(EventType.leave, flowContext, flowInstance);
        final BranchCounter branchCounter = new BranchCounter();
        final int n = arrayList.size();
        final boolean bl = this.forkNodeMultiThreadSupport();
        final ConcurrentHashMap<Object, Integer> concurrentHashMap = new ConcurrentHashMap<Object, Integer>();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            final Connection connection = (Connection)arrayList.get(i);
            if (!bl) {
                object2 = flowInstance.newChildInstance(branchCounter, n);
                ((FlowInstance)object2).addVariable("fork_node_multi_thread_support_", bl);
                connection.execute(null, flowContext, (FlowInstance)object2);
                continue;
            }
            if (i == n - 1) {
                object2 = Thread.currentThread().getName();
                if (((String)object2).startsWith("fork_node_sub_thread_")) {
                    Thread.currentThread().setName("Sub_Fork_Main_Thread_" + UUID.randomUUID().toString());
                }
                object = flowInstance.newChildInstance(branchCounter, n);
                ((FlowInstance)object).addVariable("fork_node_multi_thread_support_", bl);
                ((FlowInstance)object).addVariable("fork_node_exception_map_", concurrentHashMap);
                connection.execute(null, flowContext, (FlowInstance)object);
                continue;
            }
            object2 = "fork_node_sub_thread_" + (connection.getName() == null ? "" : connection.getName() + "_") + this.getName() + i + "_" + UUID.randomUUID().toString();
            object = new Thread(){

                @Override
                public void run() {
                    try {
                        FlowInstance flowInstance2 = flowInstance.newChildInstance(branchCounter, n);
                        flowInstance2.addVariable("fork_node_multi_thread_support_", bl);
                        flowInstance2.addVariable("fork_node_exception_map_", concurrentHashMap);
                        connection.execute(null, flowContext, flowInstance2);
                    }
                    catch (Exception exception) {
                        concurrentHashMap.put(this, exception);
                    }
                }
            };
            concurrentHashMap.put(object, 1);
            ((Thread)object).setName((String)object2);
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
        }
    }

    private boolean forkNodeMultiThreadSupport() {
        String string = PropertyConfigurer.getProperty("urule.flowForkMultiThread");
        boolean bl = false;
        if (StringUtils.isNotBlank((String)string)) {
            bl = Boolean.valueOf(string);
        }
        boolean bl2 = false;
        bl2 = StringUtils.isBlank((String)this.multipleThread) || this.multipleThread.equals("default") ? bl : this.multipleThread.equals("yes");
        return bl2;
    }

    public String getMultipleThread() {
        return this.multipleThread;
    }

    public void setMultipleThread(String string) {
        this.multipleThread = string;
    }
}

