/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.flow;

import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.flow.EventType;
import com.bstek.urule.model.flow.FlowNode;
import com.bstek.urule.model.flow.FlowNodeType;
import com.bstek.urule.model.flow.ins.FlowContext;
import com.bstek.urule.model.flow.ins.FlowInstance;
import java.util.Map;

public class JoinNode
extends FlowNode {
    private FlowNodeType type = FlowNodeType.Join;

    public JoinNode() {
    }

    public JoinNode(String string) {
        super(string);
    }

    @Override
    public FlowNodeType getType() {
        return this.type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void enterNode(Exception exception, FlowContext flowContext, FlowInstance flowInstance) {
        FlowInstance flowInstance2 = flowInstance.getParent();
        if (flowInstance2 == null) {
            throw new RuleException("Invalid flow instance.");
        }
        int n = flowInstance.getParallelInstanceCount();
        boolean bl = (Boolean)flowInstance.getVariable("fork_node_multi_thread_support_");
        if (bl) {
            int n2 = flowInstance.riseArrivedBranch();
            String string = Thread.currentThread().getName();
            if (string != null && string.startsWith("fork_node_sub_thread_")) {
                return;
            }
            if (n2 >= n) {
                this.doLeave(flowContext, flowInstance2);
                return;
            }
            Map map = (Map)flowInstance.getVariable("fork_node_exception_map_");
            flowInstance.removeVariable("fork_node_exception_map_");
            while (true) {
                if ((n2 = flowInstance.getArrivedBranchSize()) >= n) {
                    this.doLeave(flowContext, flowInstance2);
                    return;
                }
                Exception exception2 = null;
                for (Thread thread : map.keySet()) {
                    Object v = map.get(thread);
                    if (!(v instanceof Exception)) continue;
                    exception2 = (Exception)v;
                }
                if (exception2 != null) {
                    for (Thread thread : map.keySet()) {
                        thread.interrupt();
                    }
                    throw new RuleException(exception2);
                }
                Thread.yield();
            }
        }
        flowInstance.riseArrivedBranch();
        int n3 = flowInstance.getArrivedBranchSize();
        if (n3 < n) return;
        this.doLeave(flowContext, flowInstance2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLeave(FlowContext flowContext, FlowInstance flowInstance) {
        Exception exception = null;
        try {
            flowInstance.setCurrentNode(this);
            this.executeNodeEvent(EventType.enter, flowContext, flowInstance);
            this.executeNodeEvent(EventType.leave, flowContext, flowInstance);
            String string = flowInstance.getId() + this.getName();
            flowContext.removeVariable(string);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        finally {
            this.leave(null, flowContext, flowInstance, exception);
        }
    }
}

