/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.flow.ins;

import com.bstek.urule.model.flow.FlowNode;
import com.bstek.urule.model.flow.ProcessDefinition;
import com.bstek.urule.model.flow.ins.BranchCounter;
import com.bstek.urule.model.flow.ins.ProcessInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class FlowInstance
implements ProcessInstance {
    private String id;
    private int parallelInstanceCount;
    private ProcessDefinition flowDefinition;
    private FlowInstance parent;
    private BranchCounter branchCounter;
    private List<ProcessInstance> children = new ArrayList<ProcessInstance>();
    private FlowNode currentNode;
    private boolean debug;
    private Map<String, Object> variablesMap = new HashMap<String, Object>();

    public FlowInstance(ProcessDefinition processDefinition, boolean bl) {
        this.flowDefinition = processDefinition;
        this.id = UUID.randomUUID().toString();
        this.debug = bl;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Object getVariable(String string) {
        return this.variablesMap.get(string);
    }

    public void addVariable(String string, Object object) {
        this.variablesMap.put(string, object);
    }

    public void removeVariable(String string) {
        this.variablesMap.remove(string);
    }

    public int riseArrivedBranch() {
        return this.branchCounter.rise();
    }

    public int getArrivedBranchSize() {
        return this.branchCounter.getCount();
    }

    public BranchCounter getBranchCounter() {
        return this.branchCounter;
    }

    public void setBranchCounter(BranchCounter branchCounter) {
        this.branchCounter = branchCounter;
    }

    @Override
    public ProcessDefinition getProcessDefinition() {
        return this.flowDefinition;
    }

    @Override
    public List<ProcessInstance> getChildren() {
        return this.children;
    }

    public void addChild(FlowInstance flowInstance) {
        this.children.add(flowInstance);
    }

    @Override
    public int getParallelInstanceCount() {
        return this.parallelInstanceCount;
    }

    public void setParallelInstanceCount(int n) {
        this.parallelInstanceCount = n;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public FlowNode getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(FlowNode flowNode) {
        this.currentNode = flowNode;
    }

    public void setParent(FlowInstance flowInstance) {
        this.parent = flowInstance;
    }

    @Override
    public FlowInstance getParent() {
        return this.parent;
    }

    public FlowInstance newChildInstance(BranchCounter branchCounter, int n) {
        FlowInstance flowInstance = new FlowInstance(this.flowDefinition, this.debug);
        flowInstance.setBranchCounter(branchCounter);
        flowInstance.setParallelInstanceCount(n);
        flowInstance.setParent(this);
        this.addChild(flowInstance);
        return flowInstance;
    }
}

