/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.library;

import com.bstek.urule.Utils;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.HashMapTypeReference;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public enum Datatype {
    String,
    Integer,
    Char,
    Double,
    Long,
    Float,
    BigDecimal,
    Boolean,
    Date,
    List,
    Set,
    Map,
    Enum,
    Object;


    public static final Datatype parse(String string) {
        if (string.equals(String.toString())) {
            return String;
        }
        if (string.equals(Integer.toString())) {
            return Integer;
        }
        if (string.equals(Char.toString())) {
            return Char;
        }
        if (string.equals(Double.toString())) {
            return Double;
        }
        if (string.equals(Long.toString())) {
            return Long;
        }
        if (string.equals(Float.toString())) {
            return Float;
        }
        if (string.equals(BigDecimal.toString())) {
            return BigDecimal;
        }
        if (string.equals(Boolean.toString())) {
            return Boolean;
        }
        if (string.equals(Date.toString())) {
            return Date;
        }
        if (string.equals(List.toString())) {
            return List;
        }
        if (string.equals(Set.toString())) {
            return Set;
        }
        if (string.equals(Map.toString())) {
            return Map;
        }
        if (string.equals(Enum.toString())) {
            return Enum;
        }
        return Object;
    }

    public String convertObjectToString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return object.toString();
        }
        switch (this) {
            case Object: {
                return object.toString();
            }
            case Date: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return simpleDateFormat.format((Date)object);
            }
            case List: {
                List list = (List)object;
                String string = "";
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (i > 0) {
                        string = string + ",";
                    }
                    string = string + e;
                }
                return string;
            }
            case Set: {
                Set set = (Set)object;
                String string = "";
                int n = 0;
                for (Object e : set) {
                    if (n > 0) {
                        string = string + ",";
                    }
                    string = string + e;
                    ++n;
                }
                return string;
            }
            case BigDecimal: {
                BigDecimal bigDecimal = Utils.toBigDecimal(object);
                return bigDecimal.floatValue() + "";
            }
            case Double: {
                Double d = Utils.toBigDecimal(object).doubleValue();
                return d.floatValue() + "";
            }
        }
        return object.toString();
    }

    public Object convert(Object object) {
        switch (this) {
            case Object: {
                return object;
            }
            case String: {
                if (object == null) {
                    return object;
                }
                if (object instanceof Number) {
                    BigDecimal bigDecimal = Utils.toBigDecimal(object);
                    object = bigDecimal.toPlainString();
                }
                return object.toString();
            }
            case Integer: {
                if (object == null || object.toString().equals("")) {
                    object = "0";
                }
                return Utils.toBigDecimal(object).intValue();
            }
            case Char: {
                if (object == null) {
                    return Character.valueOf('\u0000');
                }
                if (object instanceof Character) {
                    return (Character)object;
                }
                String string = object.toString();
                if (string.length() == 1) {
                    return Character.valueOf(string.toCharArray()[0]);
                }
                int n = Utils.toBigDecimal(object).intValue();
                return Character.valueOf((char)n);
            }
            case Double: {
                if (object == null) {
                    object = "0";
                }
                return Utils.toBigDecimal(object).doubleValue();
            }
            case Long: {
                if (object == null) {
                    object = "0";
                }
                return Utils.toBigDecimal(object).longValue();
            }
            case Float: {
                if (object == null) {
                    object = "0";
                }
                return java.lang.Float.valueOf(Utils.toBigDecimal(object).floatValue());
            }
            case BigDecimal: {
                if (object == null) {
                    object = "0";
                }
                return Utils.toBigDecimal(object);
            }
            case Boolean: {
                if (object == null) {
                    object = "false";
                }
                return java.lang.Boolean.valueOf(object.toString());
            }
            case Date: {
                if (object == null) {
                    return null;
                }
                try {
                    if (object instanceof Date) {
                        return (Date)object;
                    }
                    if (object.toString().equals("")) {
                        return null;
                    }
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        return simpleDateFormat.parse(object.toString());
                    }
                    catch (Exception exception) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                        try {
                            return simpleDateFormat.parse(object.toString());
                        }
                        catch (Exception exception2) {
                            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                            return simpleDateFormat.parse(object.toString());
                        }
                    }
                }
                catch (ParseException parseException) {
                    throw new RuleException(parseException);
                }
            }
            case List: {
                String[] stringArray;
                if (object == null) {
                    return null;
                }
                if (object instanceof List) {
                    return (List)object;
                }
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    return new ArrayList(collection);
                }
                String string = object.toString();
                if (string.startsWith("[") && string.endsWith("]")) {
                    ObjectMapper objectMapper = JsonMapper.builder().build();
                    try {
                        return objectMapper.readValue(object.toString(), ArrayList.class);
                    }
                    catch (Exception exception) {
                        throw new RuleException(exception);
                    }
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string2 : stringArray = string.split(",")) {
                    arrayList.add(string2);
                }
                return arrayList;
            }
            case Set: {
                if (object == null) {
                    return null;
                }
                if (object instanceof Set) {
                    return (Set)object;
                }
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    return new HashSet(collection);
                }
                String string = object.toString();
                if (string.startsWith("[") && string.endsWith("]")) {
                    ObjectMapper objectMapper = JsonMapper.builder().build();
                    try {
                        return objectMapper.readValue(object.toString(), HashSet.class);
                    }
                    catch (Exception exception) {
                        throw new RuleException(exception);
                    }
                }
                TreeSet<String> treeSet = new TreeSet<String>();
                for (String string3 : string.split(",")) {
                    treeSet.add(string3);
                }
                return treeSet;
            }
            case Map: {
                if (object == null) {
                    return null;
                }
                if (object instanceof Map) {
                    return (Map)object;
                }
                ObjectMapper objectMapper = JsonMapper.builder().build();
                try {
                    Map map = (Map)objectMapper.readValue(object.toString(), (TypeReference)new HashMapTypeReference());
                    return map;
                }
                catch (Exception exception) {
                    throw new RuleException(exception);
                }
            }
            case Enum: {
                return object;
            }
        }
        return null;
    }
}

