/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.library;

import com.bstek.urule.model.library.action.ActionData;
import com.bstek.urule.model.library.action.ActionLibrary;
import com.bstek.urule.model.library.action.Method;
import com.bstek.urule.model.library.action.SpringBean;
import com.bstek.urule.model.library.constant.Constant;
import com.bstek.urule.model.library.constant.ConstantCategory;
import com.bstek.urule.model.library.constant.ConstantData;
import com.bstek.urule.model.library.constant.ConstantLibrary;
import com.bstek.urule.model.library.variable.Variable;
import com.bstek.urule.model.library.variable.VariableCategory;
import com.bstek.urule.model.library.variable.VariableData;
import com.bstek.urule.model.library.variable.VariableLibrary;
import com.bstek.urule.model.template.ActionTemplate;
import com.bstek.urule.model.template.ActionTemplateUnit;
import com.bstek.urule.model.template.ConditionTemplate;
import com.bstek.urule.model.template.ConditionTemplateUnit;
import java.util.ArrayList;
import java.util.List;

public class ResourceLibrary {
    private List<ConditionTemplateUnit> conditionTemplateUnits;
    private List<ActionTemplateUnit> actionTemplateUnits;
    private List<ConstantCategory> constantCategories;
    private List<ActionLibrary> actionLibraries;
    private List<VariableCategory> variableCategories;

    public ResourceLibrary() {
    }

    public ResourceLibrary(List<VariableCategory> list) {
        this.variableCategories = list;
        this.actionLibraries = new ArrayList<ActionLibrary>();
        this.constantCategories = new ArrayList<ConstantCategory>();
        this.conditionTemplateUnits = new ArrayList<ConditionTemplateUnit>();
        this.actionTemplateUnits = new ArrayList<ActionTemplateUnit>();
    }

    public ResourceLibrary(List<VariableLibrary> list, List<ActionLibrary> list2, List<ConstantLibrary> list3, List<ConditionTemplate> list4, List<ActionTemplate> list5) {
        this.variableCategories = new ArrayList<VariableCategory>();
        this.actionLibraries = new ArrayList<ActionLibrary>();
        this.constantCategories = new ArrayList<ConstantCategory>();
        this.conditionTemplateUnits = new ArrayList<ConditionTemplateUnit>();
        this.actionTemplateUnits = new ArrayList<ActionTemplateUnit>();
        for (VariableLibrary object : list) {
            for (VariableCategory variableCategory : object.getVariableCategories()) {
                this.variableCategories.add(variableCategory);
            }
        }
        this.actionLibraries.addAll(list2);
        for (ConstantLibrary constantLibrary : list3) {
            for (ConstantCategory constantCategory : constantLibrary.getCategories()) {
                this.constantCategories.add(constantCategory);
            }
        }
        for (ConditionTemplate conditionTemplate : list4) {
            this.conditionTemplateUnits.addAll(conditionTemplate.getTemplates());
        }
        for (ActionTemplate actionTemplate : list5) {
            this.actionTemplateUnits.addAll(actionTemplate.getTemplates());
        }
    }

    public ConditionTemplateUnit getConditionTemplateUnit(String string) {
        for (ConditionTemplateUnit conditionTemplateUnit : this.conditionTemplateUnits) {
            if (!conditionTemplateUnit.getId().equals(string)) continue;
            return conditionTemplateUnit;
        }
        return null;
    }

    public ActionTemplateUnit getActionTemplateUnit(String string) {
        for (ActionTemplateUnit actionTemplateUnit : this.actionTemplateUnits) {
            if (!actionTemplateUnit.getId().equals(string)) continue;
            return actionTemplateUnit;
        }
        return null;
    }

    public VariableCategory getVariableCategoryByUuid(String string) {
        for (VariableCategory variableCategory : this.variableCategories) {
            if (!variableCategory.getUuid().equals(string)) continue;
            return variableCategory;
        }
        return null;
    }

    public VariableCategory getVariableCategoryByCategoryName(String string) {
        for (VariableCategory variableCategory : this.variableCategories) {
            if (!variableCategory.getName().equals(string)) continue;
            return variableCategory;
        }
        return null;
    }

    public VariableData getVariableByName(String string, String string2) {
        for (VariableCategory variableCategory : this.variableCategories) {
            if (!variableCategory.getName().equals(string)) continue;
            for (Variable variable : variableCategory.getVariables()) {
                if (!variable.getName().equals(string2)) continue;
                return new VariableData(variableCategory, variable);
            }
        }
        return null;
    }

    public VariableData getVariableByUuid(String string, String string2) {
        for (VariableCategory variableCategory : this.variableCategories) {
            if (!variableCategory.getUuid().equals(string)) continue;
            for (Variable variable : variableCategory.getVariables()) {
                if (!variable.getUuid().equals(string2)) continue;
                return new VariableData(variableCategory, variable);
            }
        }
        return null;
    }

    public ActionData getActionByUuid(String string, String string2) {
        for (ActionLibrary actionLibrary : this.actionLibraries) {
            List<SpringBean> list = actionLibrary.getSpringBeans();
            for (SpringBean springBean : list) {
                if (!string.equals(springBean.getUuid())) continue;
                for (Method method : springBean.getMethods()) {
                    if (!method.getUuid().contentEquals(string2)) continue;
                    return new ActionData(springBean, method);
                }
            }
        }
        return null;
    }

    public ActionData getActionByName(String string, String string2) {
        for (ActionLibrary actionLibrary : this.actionLibraries) {
            List<SpringBean> list = actionLibrary.getSpringBeans();
            for (SpringBean springBean : list) {
                if (!string.equals(springBean.getName())) continue;
                for (Method method : springBean.getMethods()) {
                    if (!method.getName().contentEquals(string2)) continue;
                    return new ActionData(springBean, method);
                }
            }
        }
        return null;
    }

    public ConstantData getConstantByUuid(String string, String string2) {
        for (ConstantCategory constantCategory : this.constantCategories) {
            if (!constantCategory.getUuid().equals(string)) continue;
            for (Constant constant : constantCategory.getConstants()) {
                if (!constant.getUuid().equals(string2)) continue;
                return new ConstantData(constantCategory, constant);
            }
        }
        return null;
    }

    public List<ActionLibrary> getActionLibraries() {
        return this.actionLibraries;
    }

    public List<VariableCategory> getVariableCategories() {
        return this.variableCategories;
    }

    public List<ConstantCategory> getConstantCategories() {
        return this.constantCategories;
    }
}

