/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.library.variable;

import com.bstek.urule.model.library.variable.Act;
import com.bstek.urule.model.library.variable.CategoryType;
import com.bstek.urule.model.library.variable.Variable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class VariableCategory {
    public static final String PARAM_CATEGORY = "\u53c2\u6570";
    private String uuid;
    private String name;
    private CategoryType type;
    private String clazz;
    private String file;
    private Act act = Act.InOut;
    private List<Variable> variables = new ArrayList<Variable>();
    @JsonIgnore
    private Map<String, Variable> variableNames = new HashMap<String, Variable>();
    @JsonIgnore
    private Map<String, Variable> variableLabels = new HashMap<String, Variable>();

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String string) {
        this.uuid = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public CategoryType getType() {
        return this.type;
    }

    public void setType(CategoryType categoryType) {
        this.type = categoryType;
    }

    public Act getAct() {
        return this.act;
    }

    public void setAct(Act act) {
        this.act = act;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String string) {
        this.clazz = string;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public VariableCategory newVariableCategoryWithDefaultValue() {
        VariableCategory variableCategory = new VariableCategory();
        variableCategory.setName(this.name);
        variableCategory.setAct(this.act);
        variableCategory.setClazz(this.clazz);
        variableCategory.setFile(this.file);
        variableCategory.setType(this.type);
        for (Variable variable : this.variables) {
            if (variable.getDefaultValue() == null) continue;
            variableCategory.addVariable(variable);
        }
        return variableCategory;
    }

    public void setVariables(List<Variable> list) {
        this.variables = list;
        this.variableNames.clear();
        this.variableLabels.clear();
        for (Variable variable : list) {
            this.variableNames.put(variable.getName(), variable);
            this.variableLabels.put(variable.getLabel(), variable);
        }
    }

    public void addVariable(Variable variable) {
        this.variables.add(variable);
        if (StringUtils.isNotBlank((String)variable.getName())) {
            this.variableNames.put(variable.getName(), variable);
        }
        if (StringUtils.isNotBlank((String)variable.getLabel())) {
            this.variableLabels.put(variable.getLabel(), variable);
        }
    }

    public Map<String, Variable> getVariableNames() {
        return this.variableNames;
    }

    public void setVariableNames(Map<String, Variable> map) {
        this.variableNames = map;
    }

    public Map<String, Variable> getVariableLabels() {
        return this.variableLabels;
    }

    public void setVariableLabels(Map<String, Variable> map) {
        this.variableLabels = map;
    }
}

