/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.urule.model.rete;

import com.bstek.urule.Configure;
import com.bstek.urule.exception.RuleException;
import com.bstek.urule.model.library.Datatype;
import com.bstek.urule.model.rete.jsondeserializer.CommonFunctionValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.ConstantValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.InputValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.MathValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.MethodValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.ParameterValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.ParenValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.SingIValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.ValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.VariableCategoryValueDeserializer;
import com.bstek.urule.model.rete.jsondeserializer.VariableValueDeserializer;
import com.bstek.urule.model.rule.ArithmeticType;
import com.bstek.urule.model.rule.ComplexArithmetic;
import com.bstek.urule.model.rule.Parameter;
import com.bstek.urule.model.rule.Value;
import com.bstek.urule.model.rule.ValueType;
import com.bstek.urule.model.rule.lhs.CommonFunctionParameter;
import com.bstek.urule.runtime.KnowledgePackageWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JsonUtils {
    private static List<ValueDeserializer> valueDeserializers = new ArrayList<ValueDeserializer>();

    public static String getJsonValue(JsonNode jsonNode, String string) {
        if (jsonNode.get(string) != null) {
            return jsonNode.get(string).asText();
        }
        return null;
    }

    public static ComplexArithmetic parseComplexArithmetic(JsonNode jsonNode) {
        JsonNode jsonNode2 = jsonNode.get("arithmetic");
        if (jsonNode2 == null) {
            return null;
        }
        ComplexArithmetic complexArithmetic = new ComplexArithmetic();
        complexArithmetic.setType(ArithmeticType.valueOf(JsonUtils.getJsonValue(jsonNode2, "type")));
        complexArithmetic.setValue(JsonUtils.parseValue(jsonNode2));
        return complexArithmetic;
    }

    public static List<Parameter> parseParameters(JsonNode jsonNode) {
        JsonNode jsonNode2 = jsonNode.get("parameters");
        if (jsonNode2 == null) {
            return null;
        }
        Iterator iterator = jsonNode2.iterator();
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        while (iterator.hasNext()) {
            String string;
            JsonNode jsonNode3 = (JsonNode)iterator.next();
            Parameter parameter = new Parameter();
            parameter.setName(JsonUtils.getJsonValue(jsonNode3, "name"));
            String string2 = JsonUtils.getJsonValue(jsonNode3, "type");
            if (string2 != null) {
                parameter.setType(Datatype.valueOf(string2));
            }
            if ((string = JsonUtils.getJsonValue(jsonNode3, "valueType")) != null) {
                parameter.setValue(JsonUtils.parseValue(jsonNode3));
            }
            parameter.setValue(JsonUtils.parseValue(jsonNode3));
            arrayList.add(parameter);
        }
        return arrayList;
    }

    public static Value parseValueNode(JsonNode jsonNode) {
        Value value = null;
        ValueType valueType = ValueType.valueOf(JsonUtils.getJsonValue(jsonNode, "valueType"));
        for (ValueDeserializer valueDeserializer : valueDeserializers) {
            if (!valueDeserializer.support(valueType)) continue;
            value = valueDeserializer.deserialize(jsonNode);
            break;
        }
        return value;
    }

    public static KnowledgePackageWrapper parseKnowledgePackageWrapper(String string) {
        try {
            ObjectMapper objectMapper = JsonMapper.builder().build();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Configure.getDateFormat());
            objectMapper.getDeserializationConfig().with((DateFormat)simpleDateFormat);
            objectMapper.setDateFormat((DateFormat)simpleDateFormat);
            KnowledgePackageWrapper knowledgePackageWrapper = (KnowledgePackageWrapper)objectMapper.readValue(string, KnowledgePackageWrapper.class);
            knowledgePackageWrapper.buildDeserialize();
            return knowledgePackageWrapper;
        }
        catch (Exception exception) {
            throw new RuleException(exception);
        }
    }

    public static CommonFunctionParameter parseCommonFunctionParameter(JsonNode jsonNode) {
        JsonNode jsonNode2 = jsonNode.get("parameter");
        if (jsonNode2 == null) {
            return null;
        }
        CommonFunctionParameter commonFunctionParameter = new CommonFunctionParameter();
        commonFunctionParameter.setName(JsonUtils.getJsonValue(jsonNode2, "name"));
        commonFunctionParameter.setProperty(JsonUtils.getJsonValue(jsonNode2, "property"));
        commonFunctionParameter.setPropertyLabel(JsonUtils.getJsonValue(jsonNode2, "propertyLabel"));
        commonFunctionParameter.setObjectParameter(JsonUtils.parseValueNode(jsonNode2.get("objectParameter")));
        return commonFunctionParameter;
    }

    public static Value parseValue(JsonNode jsonNode) {
        JsonNode jsonNode2 = jsonNode.get("value");
        if (jsonNode2 == null) {
            return null;
        }
        return JsonUtils.parseValueNode(jsonNode2);
    }

    public static List<ValueDeserializer> getValueDeserializers() {
        return valueDeserializers;
    }

    static {
        valueDeserializers.add(new ConstantValueDeserializer());
        valueDeserializers.add(new InputValueDeserializer());
        valueDeserializers.add(new ParameterValueDeserializer());
        valueDeserializers.add(new MethodValueDeserializer());
        valueDeserializers.add(new VariableCategoryValueDeserializer());
        valueDeserializers.add(new VariableValueDeserializer());
        valueDeserializers.add(new CommonFunctionValueDeserializer());
        valueDeserializers.add(new ParenValueDeserializer());
        valueDeserializers.add(new MathValueDeserializer());
        valueDeserializers.add(new SingIValueDeserializer());
    }
}

